/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.navigator;

import at.dallermassl.josm.plugin.navigator.NavigatorLayer;
import at.dallermassl.josm.plugin.navigator.NavigatorModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NavigatorModeAction
extends MapMode {
    private NavigatorModel navigatorModel;
    private NavigatorLayer navigatorLayer;
    private boolean layerAdded;

    public NavigatorModeAction(MapFrame mapFrame, NavigatorModel navigatorModel, NavigatorLayer navigationLayer) {
        super(I18n.tr((String)"Navigator"), "navigation", I18n.tr((String)"Set start/end for autorouting. Middle Mouse button to reset."), 70, mapFrame, ImageProvider.getCursor((String)"crosshair", (String)"selection"));
        this.navigatorModel = navigatorModel;
        this.navigatorLayer = navigationLayer;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        if (!this.layerAdded) {
            System.out.println("Adding navigatorlayer " + (Object)((Object)this.navigatorLayer));
            Main.main.addLayer((Layer)this.navigatorLayer);
            this.layerAdded = true;
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 2) {
            this.navigatorModel.reset();
        } else if (e.getButton() == 1) {
            Node node = Main.map.mapView.getNearestNode(e.getPoint());
            System.out.println("selected node " + node);
            if (node == null) {
                return;
            }
            this.navigatorModel.addNode(node);
        }
        Main.map.repaint();
    }
}

