/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.navigator;

import at.dallermassl.josm.plugin.navigator.NavigatorModel;
import at.dallermassl.josm.plugin.navigator.SegmentEdge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.ImageProvider;

public class NavigatorLayer
extends Layer {
    private static final String KEY_ROUTE_COLOR = "color.navigator.route";
    private static final String KEY_ROUTE_WIDTH = "navigator.route.width";
    private static final String KEY_ROUTE_SELECT = "navigator.route.select";
    protected static final double ARROW_PHI = Math.toRadians(20.0);
    private NavigatorModel navigatorNodeModel;
    private Icon startIcon;
    private Icon middleIcon;
    private Icon endIcon;

    public NavigatorLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        ImageIcon icon = ImageProvider.get((String)"layer", (String)"navigation_small");
        return icon;
    }

    public Object getInfoComponent() {
        return "Navigation layer";
    }

    public Component[] getMenuEntries() {
        return null;
    }

    public String getToolTipText() {
        return "Tool Tip for Navigation";
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics g, MapView mv) {
        String colorString;
        List<Node> nodes = this.navigatorNodeModel.getSelectedNodes();
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        if (this.startIcon == null) {
            this.startIcon = ImageProvider.get((String)"navigation", (String)"startflag");
            this.middleIcon = ImageProvider.get((String)"navigation", (String)"middleflag");
            this.endIcon = ImageProvider.get((String)"navigation", (String)"endflag");
        }
        Node node = nodes.get(0);
        Point screen = mv.getPoint(node.eastNorth);
        this.startIcon.paintIcon((Component)mv, g, screen.x, screen.y - this.startIcon.getIconHeight());
        for (int index = 1; index < nodes.size() - 1; ++index) {
            node = nodes.get(index);
            screen = mv.getPoint(node.eastNorth);
            this.middleIcon.paintIcon((Component)mv, g, screen.x, screen.y - this.middleIcon.getIconHeight());
        }
        if (nodes.size() > 1) {
            node = nodes.get(nodes.size() - 1);
            screen = mv.getPoint(node.eastNorth);
            this.endIcon.paintIcon((Component)mv, g, screen.x, screen.y - this.endIcon.getIconHeight());
        }
        if ((colorString = Main.pref.get(KEY_ROUTE_COLOR)).length() == 0) {
            colorString = ColorHelper.color2html((Color)Color.GREEN);
        }
        Color color = ColorHelper.html2color((String)colorString);
        String widthString = Main.pref.get(KEY_ROUTE_WIDTH);
        if (widthString.length() == 0) {
            widthString = "5";
        }
        int width = Integer.parseInt(widthString);
        List<SegmentEdge> edgePath = this.navigatorNodeModel.getEdgePath();
        if (edgePath != null) {
            for (SegmentEdge edge : edgePath) {
                this.drawSegmentEdge(g, mv, edge, color, width, true);
            }
        }
    }

    protected void drawSegmentEdge(Graphics g, MapView mv, SegmentEdge edge, Color col, int width, boolean showDirection) {
        Point to;
        Point from;
        g.setColor(col);
        if (!edge.isInverted()) {
            from = mv.getPoint(edge.getSegment().from.eastNorth);
            to = mv.getPoint(edge.getSegment().to.eastNorth);
        } else {
            from = mv.getPoint(edge.getSegment().to.eastNorth);
            to = mv.getPoint(edge.getSegment().from.eastNorth);
        }
        Rectangle screen = g.getClipBounds();
        Line2D.Double line = new Line2D.Double(from.x, from.y, to.x, to.y);
        if (screen.contains(from.x, from.y, to.x, to.y) || screen.intersectsLine(line)) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(width));
            g.drawLine(from.x, from.y, to.x, to.y);
            if (showDirection) {
                double t = Math.atan2(to.y - from.y, to.x - from.x) + Math.PI;
                g.drawLine(to.x, to.y, (int)((double)to.x + 10.0 * Math.cos(t - ARROW_PHI)), (int)((double)to.y + 10.0 * Math.sin(t - ARROW_PHI)));
                g.drawLine(to.x, to.y, (int)((double)to.x + 10.0 * Math.cos(t + ARROW_PHI)), (int)((double)to.y + 10.0 * Math.sin(t + ARROW_PHI)));
            }
            g2d.setStroke(oldStroke);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node node : this.navigatorNodeModel.getSelectedNodes()) {
            v.visit(node);
        }
    }

    public NavigatorModel getNavigatorNodeModel() {
        return this.navigatorNodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate() {
        List<Segment> path;
        this.navigatorNodeModel.calculateShortesPath();
        Main.pref.hasKey(KEY_ROUTE_COLOR);
        String selectString = Main.pref.get(KEY_ROUTE_SELECT);
        if (selectString.length() == 0) {
            selectString = "true";
            Main.pref.put(KEY_ROUTE_SELECT, selectString);
        }
        if (Boolean.parseBoolean(selectString) && (path = this.navigatorNodeModel.getSegmentPath()) != null) {
            List<Segment> list = path;
            synchronized (list) {
                Main.ds.setSelected(path);
            }
        }
        Main.map.repaint();
    }

    public void setNavigatorNodeModel(NavigatorModel navigatorNodeModel) {
        this.navigatorNodeModel = navigatorNodeModel;
    }
}

