/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.OSGBLayer;
import wmsplugin.WMSLayer;

public class DownloadWMSTask
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private double minlat;
    private double minlon;
    private double maxlat;
    private double maxlon;
    private boolean layerAdded = false;

    public DownloadWMSTask(String name, String wmsurl) {
        super(I18n.tr((String)("Downloading " + name)));
        if (this.wmsLayer == null) {
            this.wmsLayer = wmsurl.matches("(?i).*layers=npeoocmap.*") || wmsurl.matches("(?i).*layers=npe.*") ? new OSGBLayer(name, wmsurl) : new WMSLayer(name, wmsurl);
        }
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        this.wmsLayer.grab(this.minlat, this.minlon, this.maxlat, this.maxlon);
    }

    protected void finish() {
        this.layerAdded = false;
        for (Object element : Main.map.mapView.getAllLayers()) {
            if (!element.equals((Object)this.wmsLayer)) continue;
            this.layerAdded = true;
        }
        if (this.wmsLayer != null && !this.layerAdded) {
            Main.main.addLayer((Layer)this.wmsLayer);
            this.layerAdded = true;
        }
    }

    protected void cancel() {
    }

    public void download(DownloadAction action, double minlat, double minlon, double maxlat, double maxlon) {
        this.minlat = minlat;
        this.minlon = minlon;
        this.maxlat = maxlat;
        this.maxlon = maxlon;
        Main.worker.execute((Runnable)((Object)this));
    }
}

