/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.RefEll;

public class UTMRef {
    private double easting;
    private double northing;
    private char latZone;
    private int lngZone;

    public UTMRef(double easting, double northing, char latZone, int lngZone) {
        this.easting = easting;
        this.northing = northing;
        this.latZone = latZone;
        this.lngZone = lngZone;
    }

    public LatLng toLatLng() {
        double UTM_F0 = 0.9996;
        double a = RefEll.WGS84.getMaj();
        double eSquared = RefEll.WGS84.getEcc();
        double ePrimeSquared = eSquared / (1.0 - eSquared);
        double e1 = (1.0 - Math.sqrt(1.0 - eSquared)) / (1.0 + Math.sqrt(1.0 - eSquared));
        double x = this.easting - 500000.0;
        double y = this.northing;
        int zoneNumber = this.lngZone;
        char zoneLetter = this.latZone;
        double longitudeOrigin = ((double)zoneNumber - 1.0) * 6.0 - 180.0 + 3.0;
        if (zoneLetter - 78 < 0) {
            y -= 1.0E7;
        }
        double m = y / UTM_F0;
        double mu = m / (a * (1.0 - eSquared / 4.0 - 3.0 * eSquared * eSquared / 64.0 - 5.0 * Math.pow(eSquared, 3.0) / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * Math.pow(e1, 3.0) / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * Math.pow(e1, 4.0) / 32.0) * Math.sin(4.0 * mu) + 151.0 * Math.pow(e1, 3.0) / 96.0 * Math.sin(6.0 * mu);
        double n = a / Math.sqrt(1.0 - eSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double t = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double c = ePrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double r = a * (1.0 - eSquared) / Math.pow(1.0 - eSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double d = x / (n * UTM_F0);
        double latitude = (phi1Rad - n * Math.tan(phi1Rad) / r * (d * d / 2.0 - (5.0 + 3.0 * t + 10.0 * c - 4.0 * c * c - 9.0 * ePrimeSquared) * Math.pow(d, 4.0) / 24.0 + (61.0 + 90.0 * t + 298.0 * c + 45.0 * t * t - 252.0 * ePrimeSquared - 3.0 * c * c) * Math.pow(d, 6.0) / 720.0)) * 57.29577951308232;
        double longitude = longitudeOrigin + (d - (1.0 + 2.0 * t + c) * Math.pow(d, 3.0) / 6.0 + (5.0 - 2.0 * c + 28.0 * t - 3.0 * c * c + 8.0 * ePrimeSquared + 24.0 * t * t) * Math.pow(d, 5.0) / 120.0) / Math.cos(phi1Rad) * 57.29577951308232;
        return new LatLng(latitude, longitude);
    }

    public static char getUTMLatitudeZoneLetter(double latitude) {
        if (84.0 >= latitude && latitude >= 72.0) {
            return 'X';
        }
        if (72.0 > latitude && latitude >= 64.0) {
            return 'W';
        }
        if (64.0 > latitude && latitude >= 56.0) {
            return 'V';
        }
        if (56.0 > latitude && latitude >= 48.0) {
            return 'U';
        }
        if (48.0 > latitude && latitude >= 40.0) {
            return 'T';
        }
        if (40.0 > latitude && latitude >= 32.0) {
            return 'S';
        }
        if (32.0 > latitude && latitude >= 24.0) {
            return 'R';
        }
        if (24.0 > latitude && latitude >= 16.0) {
            return 'Q';
        }
        if (16.0 > latitude && latitude >= 8.0) {
            return 'P';
        }
        if (8.0 > latitude && latitude >= 0.0) {
            return 'N';
        }
        if (0.0 > latitude && latitude >= -8.0) {
            return 'M';
        }
        if (-8.0 > latitude && latitude >= -16.0) {
            return 'L';
        }
        if (-16.0 > latitude && latitude >= -24.0) {
            return 'K';
        }
        if (-24.0 > latitude && latitude >= -32.0) {
            return 'J';
        }
        if (-32.0 > latitude && latitude >= -40.0) {
            return 'H';
        }
        if (-40.0 > latitude && latitude >= -48.0) {
            return 'G';
        }
        if (-48.0 > latitude && latitude >= -56.0) {
            return 'F';
        }
        if (-56.0 > latitude && latitude >= -64.0) {
            return 'E';
        }
        if (-64.0 > latitude && latitude >= -72.0) {
            return 'D';
        }
        if (-72.0 > latitude && latitude >= -80.0) {
            return 'C';
        }
        return 'Z';
    }

    public String toString() {
        return String.valueOf(this.lngZone) + Character.toString(this.latZone) + " " + this.easting + " " + this.northing;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public char getLatZone() {
        return this.latZone;
    }

    public int getLngZone() {
        return this.lngZone;
    }
}

