/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.DownloadWMSTask;
import wmsplugin.Help_WMSmenuAction;
import wmsplugin.Map_Rectifier_WMSmenuAction;
import wmsplugin.WMSAdjustAction;
import wmsplugin.WMSDownloadAction;
import wmsplugin.WMSInfo;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPreferenceEditor;

public class WMSPlugin
extends Plugin {
    static String VERSION = "2.4";
    DownloadWMSTask task;
    WMSLayer wmsLayer;
    static JMenu wmsJMenu;
    static ArrayList<WMSInfo> wmsList;

    static {
        wmsList = new ArrayList();
    }

    public WMSPlugin() {
        WMSPlugin.refreshMenu();
    }

    public static void refreshMenu() {
        wmsList.clear();
        Map prefs = Main.pref.getAllPrefix("wmsplugin.url.");
        TreeSet keys = new TreeSet(prefs.keySet());
        int prefid = 0;
        String name = null;
        String url = null;
        int lastid = -1;
        for (String key : keys) {
            String[] elements = key.split("\\.");
            if (elements.length != 4) continue;
            try {
                prefid = Integer.parseInt(elements[2]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (prefid != lastid) {
                if (name != null && url != null) {
                    wmsList.add(new WMSInfo(name, url, prefid));
                }
                name = null;
                url = null;
                lastid = prefid;
            }
            if (elements[3].equals("name")) {
                name = (String)prefs.get(key);
                continue;
            }
            if (!elements[3].equals("url")) continue;
            url = (String)prefs.get(key);
        }
        if (name != null && url != null) {
            wmsList.add(new WMSInfo(name, url, prefid));
        }
        if (wmsList.isEmpty()) {
            WMSInfo landsatInfo = new WMSInfo("Landsat", "http://onearth.jpl.nasa.gov/wms.cgi?request=GetMap&layers=global_mosaic&styles=&srs=EPSG:4326&format=image/jpeg", 1);
            landsatInfo.save();
            wmsList.add(landsatInfo);
            WMSInfo npeInfo = new WMSInfo("NPE Maps", "http://nick.dev.openstreetmap.org/openpaths/freemap.php?layers=npe&", 2);
            npeInfo.save();
            wmsList.add(npeInfo);
        }
        MainMenu menu = Main.main.menu;
        if (wmsJMenu == null) {
            wmsJMenu = new JMenu(I18n.tr((String)"WMS"));
            menu.add((Component)wmsJMenu, 3);
            wmsJMenu.setEnabled(false);
        } else {
            wmsJMenu.removeAll();
        }
        for (WMSInfo u : wmsList) {
            wmsJMenu.add(new JMenuItem((Action)((Object)new WMSDownloadAction(u))));
        }
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Map_Rectifier_WMSmenuAction())));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem(new AbstractAction("Blank Layer"){

            public void actionPerformed(ActionEvent ev) {
                Main.main.addLayer((Layer)new WMSLayer());
            }
        }));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Help_WMSmenuAction())));
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            wmsJMenu.setEnabled(true);
            Main.map.toolBarActions.addSeparator();
            Main.map.toolBarActions.add((Component)new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
        } else if (oldFrame != null && newFrame == null) {
            wmsJMenu.setEnabled(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new WMSPreferenceEditor();
    }
}

