/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.WMSImage;
import wmsplugin.WMSPlugin;

public class WMSLayer
extends Layer {
    protected static Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms_small.png")));
    protected final ArrayList<WMSImage> wmsImages;
    protected final String url;
    protected final int serializeFormatVersion = 1;

    public WMSLayer() {
        super("Blank Layer");
        this.wmsImages = new ArrayList();
        this.url = "";
    }

    public WMSLayer(String name, String url) {
        super(name);
        this.url = url;
        this.wmsImages = new ArrayList();
    }

    public void grab() throws IOException {
        MapView mv = Main.map.mapView;
        WMSImage wmsImage = new WMSImage(this.url);
        wmsImage.grab((NavigatableComponent)mv);
        this.wmsImages.add(wmsImage);
    }

    public void grab(double minlat, double minlon, double maxlat, double maxlon) throws IOException {
        MapView mv = Main.map.mapView;
        WMSImage wmsImage = new WMSImage(this.url);
        wmsImage.grab((NavigatableComponent)mv, minlat, minlon, maxlat, maxlon);
        this.wmsImages.add(wmsImage);
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        return I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.name, this.wmsImages.size()});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics g, MapView mv) {
        for (WMSImage wmsImage : this.wmsImages) {
            wmsImage.paint(g, (NavigatableComponent)mv);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public WMSImage findImage(EastNorth eastNorth) {
        for (WMSImage wmsImage : this.wmsImages) {
            if (!wmsImage.contains(eastNorth)) continue;
            return wmsImage;
        }
        return null;
    }

    public void destroy() {
        this.wmsImages.clear();
    }

    protected static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        fc.setMultiSelectionEnabled(multiple);
        int i = 0;
        while (i < ExtensionFileFilter.filters.length) {
            fc.addChoosableFileFilter((FileFilter)ExtensionFileFilter.filters[i]);
            ++i;
        }
        fc.setAcceptAllFileFilterUsed(true);
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && ((file = fc.getSelectedFile()) == null || file.exists() && JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"File exists. Overwrite?"), I18n.tr((String)"Overwrite"), 0) != 0)) {
            return null;
        }
        return fc;
    }

    public static File openFileDialog(boolean open) {
        JFileChooser fc = WMSLayer.createAndOpenFileChooser(open, false);
        if (fc == null) {
            return null;
        }
        File file = fc.getSelectedFile();
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            FileFilter ff = fc.getFileFilter();
            fn = ff instanceof ExtensionFileFilter ? "." + ((ExtensionFileFilter)ff).defaultExtension : String.valueOf(fn) + ".osm";
            file = new File(fn);
        }
        return file;
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(false);
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeInt(1);
                oos.writeInt(WMSLayer.this.wmsImages.size());
                for (WMSImage w : WMSLayer.this.wmsImages) {
                    oos.writeObject(w);
                }
                oos.close();
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(true);
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 1}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                int numImg = ois.readInt();
                int i = 0;
                while (i < numImg) {
                    WMSImage img = (WMSImage)ois.readObject();
                    WMSLayer.this.wmsImages.add(img);
                    ++i;
                }
                ois.close();
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }
}

