/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;

public class SlippyMapTile {
    private Image tileImage;
    int x;
    int y;
    int z;
    private String metadata;

    public SlippyMapTile(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void loadImage() {
        try {
            URL imageURL = new URL(SlippyMapPreferences.getMapUrl() + "/" + this.z + "/" + this.x + "/" + this.y + ".png");
            this.tileImage = Toolkit.getDefaultToolkit().createImage(imageURL);
        }
        catch (MalformedURLException mfu) {
            mfu.printStackTrace();
        }
    }

    public Image getImage() {
        return this.tileImage;
    }

    public void loadMetadata() {
        try {
            URL dev = new URL("http://tah.openstreetmap.org/Tiles/info_short.php?x=" + this.x + "&y=" + this.y + "&z=12/layer=tile");
            URLConnection devc = dev.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(devc.getInputStream()));
            this.metadata = in.readLine();
        }
        catch (Exception ex) {
            this.metadata = "error loading metadata";
        }
    }

    public void requestUpdate() {
        try {
            URL dev = new URL("http://tah.openstreetmap.org/NeedRender?x=" + this.x + "&y=" + this.y + "&priority=1&src=slippymap_plugin");
            URLConnection devc = dev.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(devc.getInputStream()));
            this.metadata = "requested: " + in.readLine();
        }
        catch (Exception ex) {
            this.metadata = "error requesting update";
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SlippyMapTile)) {
            return false;
        }
        SlippyMapTile other = (SlippyMapTile)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }
}

