/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class OverlappingWays
extends Test {
    Bag<Pair<Node, Node>, OsmPrimitive> nodePairs;

    public OverlappingWays() {
        super(I18n.tr((String)"Overlapping ways."), I18n.tr((String)"This test checks that a connection between two nodes is not used by more than one way."));
    }

    public void startTest() {
        this.nodePairs = new Bag(1000);
    }

    public void endTest() {
        for (List duplicated : this.nodePairs.values()) {
            if (duplicated.size() <= 1) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Overlapping ways"), duplicated));
        }
        this.nodePairs = null;
    }

    public void visit(Way w) {
        Node lastN = null;
        for (Node n : w.nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            if (n.hashCode() > lastN.hashCode()) {
                this.nodePairs.add((Pair<Node, Node>)new Pair((Object)lastN, (Object)n), (OsmPrimitive)w);
            } else {
                this.nodePairs.add((Pair<Node, Node>)new Pair((Object)n, (Object)lastN), (OsmPrimitive)w);
            }
            lastN = n;
        }
    }
}

