/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.VariableHelper;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;

public class PluginHelper {
    private static PluginHelper INSTANCE = new PluginHelper();
    private Map<String, JMenu> menus = new HashMap<String, JMenu>();
    private VariableHelper variableHelper;

    private PluginHelper() {
        this.registerMenu("file", Main.main.menu.fileMenu);
        this.registerMenu("view", Main.main.menu.viewMenu);
        this.registerMenu("edit", Main.main.menu.editMenu);
        this.registerMenu("tools", Main.main.menu.toolsMenu);
        this.registerMenu("connection", Main.main.menu.connectionMenu);
        this.registerMenu("layer", Main.main.menu.layerMenu);
        this.registerMenu("help", Main.main.menu.helpMenu);
        this.variableHelper = new VariableHelper();
        this.variableHelper.addAll(Main.pref.getAllPrefix(""));
        this.variableHelper.add("josm.user.dir", Main.pref.getPreferencesDir());
    }

    public static PluginHelper getInstance() {
        return INSTANCE;
    }

    public void addMainMenu(String menuId, JMenu menu) {
        Main.main.menu.add(menu);
        this.registerMenu(menuId, menu);
    }

    public void registerMenu(String menuId, JMenu menu) {
        this.menus.put(menuId, menu);
    }

    public JMenu getMenu(String menuId) {
        return this.menus.get(menuId);
    }

    public VariableHelper getVariableHelper() {
        return this.variableHelper;
    }

    public PluginInformation getPluginInfo(String pluginId) {
        for (PluginProxy plugin : Main.plugins) {
            System.out.println("compare id " + pluginId + " with " + plugin.info.name);
            if (!pluginId.equals(plugin.info.name)) continue;
            return plugin.info;
        }
        return null;
    }
}

