/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.PluginResource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDescription {
    private boolean install;
    private String id;
    private String version;
    private String installedVersion;
    private String name;
    private String description;
    private List<PluginResource> resources = new ArrayList<PluginResource>();

    public void addPluginResource(PluginResource resource) {
        this.resources.add(resource);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<PluginResource> getResources() {
        return this.resources;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        this.installedVersion = installedVersion;
    }

    public boolean isInstall() {
        return this.install;
    }

    public void setInstall(boolean install) {
        this.install = install;
    }

    public void install() {
        boolean errorReported = false;
        StringBuilder errorMessages = new StringBuilder();
        for (PluginResource resource : this.resources) {
            resource.install();
            if (resource.getErrorMessage() != null) {
                errorReported = true;
                errorMessages.append(resource.getErrorMessage()).append(", ");
                System.err.println("ERROR: " + resource.getErrorMessage());
            }
            if (resource.getErrorException() == null) continue;
            errorReported = true;
            resource.getErrorException().printStackTrace();
        }
        if (errorReported) {
            JOptionPane.showMessageDialog(Main.parent, "One or more installs had an error: " + errorMessages.toString());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", name=" + this.name + ", version=" + this.version + ", desc=" + this.description + ", resources=" + this.resources + "]";
    }
}

