/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.RawGpsLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.io.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxTrackMarkerWriter
implements XmlWriter.OsmWriterInterface {
    private final Collection<Collection<RawGpsLayer.GpsPoint>> gpsData;
    private final Collection<Marker> markers;
    private static final SimpleDateFormat gpxDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public GpxTrackMarkerWriter(Collection<Collection<RawGpsLayer.GpsPoint>> gpsData, Collection<Marker> markers) {
        this.gpsData = gpsData;
        this.markers = markers;
    }

    public void header(PrintWriter out) {
        out.println("<gpx version='1.1' creator='JOSM' xmlns='http://www.topografix.com/GPX/1/1'>");
    }

    public void write(PrintWriter out) {
        Bounds b = new Bounds(new LatLon(Double.MAX_VALUE, Double.MAX_VALUE), new LatLon(Double.MIN_VALUE, Double.MIN_VALUE));
        b = this.extendBounds(b);
        out.println("  <metadata>");
        out.println("    <bounds minlat='" + b.min.lat() + "' minlon='" + b.min.lon() + "' maxlat='" + b.max.lat() + "' maxlon='" + b.max.lon() + "' />");
        out.println("  </metadata>");
        if (this.gpsData != null && this.gpsData.size() > 0) {
            out.println("  <trk>");
            for (Collection<RawGpsLayer.GpsPoint> c : this.gpsData) {
                out.println("    <trkseg>");
                LatLon last = null;
                for (RawGpsLayer.GpsPoint p : c) {
                    if (p.latlon.equals(last)) continue;
                    last = p.latlon;
                    LatLon ll = p.latlon;
                    out.print("      <trkpt lat='" + ll.lat() + "' lon='" + ll.lon() + "'");
                    if (p.time != null && p.time.length() != 0) {
                        out.println(">");
                        out.println("        <time>" + p.time + "</time>");
                        out.println("      </trkpt>");
                        continue;
                    }
                    out.println(" />");
                }
                out.println("    </trkseg>");
            }
            out.println("  </trk>");
        }
        if (this.markers != null && this.markers.size() > 0) {
            for (Marker marker : this.markers) {
                LatLon latLon = Main.proj.eastNorth2latlon(marker.eastNorth);
                out.print("  <wpt");
                out.print(" lat='" + latLon.lat() + "'");
                out.print(" lon='" + latLon.lon() + "'");
                out.println(">");
                out.println("  <name>" + marker.text + "</name>");
                out.println("</wpt>");
            }
        }
    }

    public Bounds extendBounds(Bounds bounds) {
        if (this.gpsData != null) {
            for (Collection<RawGpsLayer.GpsPoint> c : this.gpsData) {
                for (RawGpsLayer.GpsPoint p : c) {
                    bounds.extend(p.latlon);
                }
            }
        }
        if (this.markers != null) {
            for (Marker marker : this.markers) {
                LatLon latLon = Main.proj.eastNorth2latlon(marker.eastNorth);
                bounds.extend(latLon);
            }
        }
        return bounds;
    }

    public void footer(PrintWriter out) {
        out.println("</gpx>");
    }
}

