/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapTile;
import org.openstreetmap.josm.tools.ImageProvider;

public class SlippyMapLayer
extends Layer
implements ImageObserver,
Preferences.PreferenceChangedListener {
    ArrayList<HashMap<Integer, SlippyMapTile>> tileStorage = null;
    Point[][] pixelpos = new Point[21][21];
    LatLon lastTopLeft;
    LatLon lastBotRight;
    int z12x0;
    int z12x1;
    int z12y0;
    int z12y1;
    private Image bufferImage;
    private SlippyMapTile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;

    public SlippyMapLayer() {
        super("Slippy Map");
        this.clearTileStorage();
        this.tileOptionMenu = new JPopupMenu();
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Load Tile"){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadImage();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Show Tile Status"){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.loadMetadata();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Request Update"){

            public void actionPerformed(ActionEvent ae) {
                if (SlippyMapLayer.this.clickedTile != null) {
                    SlippyMapLayer.this.clickedTile.requestUpdate();
                    SlippyMapLayer.this.needRedraw = true;
                    Main.map.repaint();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction("Load All Tiles"){

            public void actionPerformed(ActionEvent ae) {
                SlippyMapLayer.this.loadAllTiles();
                SlippyMapLayer.this.needRedraw = true;
                Main.map.repaint();
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getButton() != 3) {
                            return;
                        }
                        SlippyMapLayer.this.clickedTile = SlippyMapLayer.this.getTileForPixelpos(e.getX(), e.getY());
                        SlippyMapLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                });
                Main.map.mapView.addLayerChangeListener(new MapView.LayerChangeListener(){

                    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                    }

                    public void layerAdded(Layer newLayer) {
                    }

                    public void layerRemoved(Layer oldLayer) {
                        Main.pref.listener.remove(SlippyMapLayer.this);
                    }
                });
            }
        });
        Main.pref.listener.add(this);
    }

    private void clearTileStorage() {
        this.tileStorage = new ArrayList(20);
        for (int i = 0; i < 18; ++i) {
            this.tileStorage.add(new HashMap());
        }
    }

    void loadAllTiles() {
        int tmp;
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        this.z12x0 = this.lonToTileX(topLeft.lon());
        this.z12x1 = this.lonToTileX(botRight.lon());
        this.z12y0 = this.latToTileY(topLeft.lat());
        this.z12y1 = this.latToTileY(botRight.lat());
        if (this.z12x0 > this.z12x1) {
            tmp = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = tmp;
        }
        if (this.z12y0 > this.z12y1) {
            tmp = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = tmp;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            return;
        }
        for (int x = this.z12x0 - 1; x <= this.z12x1; ++x) {
            for (int y = this.z12y0 - 1; y <= this.z12y1; ++y) {
                int key = (y << 19) + x;
                SlippyMapTile tile = this.tileStorage.get(12).get(key);
                if (tile == null) {
                    tile = new SlippyMapTile(x, y, 12);
                    this.tileStorage.get(12).put(key, tile);
                }
                if (tile.getImage() != null) continue;
                tile.loadImage();
            }
        }
    }

    public void paint(Graphics g, MapView mv) {
        int x;
        int y;
        int tmp;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        Graphics oldg = g;
        if (this.lastTopLeft != null && this.lastBotRight != null && topLeft.equalsEpsilon(this.lastTopLeft) && botRight.equalsEpsilon(this.lastBotRight) && this.bufferImage != null && mv.getWidth() == this.bufferImage.getWidth(null) && mv.getHeight() == this.bufferImage.getHeight(null) && !this.needRedraw) {
            g.drawImage(this.bufferImage, 0, 0, null);
            return;
        }
        this.needRedraw = false;
        this.lastTopLeft = topLeft;
        this.lastBotRight = botRight;
        this.bufferImage = mv.createImage(mv.getWidth(), mv.getHeight());
        g = this.bufferImage.getGraphics();
        this.z12x0 = this.lonToTileX(topLeft.lon());
        this.z12x1 = this.lonToTileX(botRight.lon());
        this.z12y0 = this.latToTileY(topLeft.lat());
        this.z12y1 = this.latToTileY(botRight.lat());
        if (this.z12x0 > this.z12x1) {
            tmp = this.z12x0;
            this.z12x0 = this.z12x1;
            this.z12x1 = tmp;
        }
        if (this.z12y0 > this.z12y1) {
            tmp = this.z12y0;
            this.z12y0 = this.z12y1;
            this.z12y1 = tmp;
        }
        if (this.z12x1 - this.z12x0 > 18) {
            return;
        }
        if (this.z12y1 - this.z12y0 > 18) {
            return;
        }
        for (int x2 = this.z12x0 - 1; x2 <= this.z12x1 + 1; ++x2) {
            double lon = this.tileXToLon(x2);
            for (y = this.z12y0 - 1; y <= this.z12y1 + 1; ++y) {
                LatLon tmpLL = new LatLon(this.tileYToLat(y), lon);
                this.pixelpos[x2 - this.z12x0 + 1][y - this.z12y0 + 1] = mv.getPoint(Main.proj.latlon2eastNorth(tmpLL));
            }
        }
        int fontHeight = g.getFontMetrics().getHeight();
        g.setColor(Color.DARK_GRAY);
        for (x = this.z12x0 - 1; x <= this.z12x1; ++x) {
            for (int y2 = this.z12y0 - 1; y2 <= this.z12y1; ++y2) {
                Image img;
                int key = (y2 << 19) + x;
                SlippyMapTile tile = this.tileStorage.get(12).get(key);
                if (tile == null) {
                    tile = new SlippyMapTile(x, y2, 12);
                    this.tileStorage.get(12).put(key, tile);
                }
                if ((img = tile.getImage()) == null) continue;
                Point p = this.pixelpos[x - this.z12x0 + 1][y2 - this.z12y0 + 1];
                Point p2 = this.pixelpos[x - this.z12x0 + 2][y2 - this.z12y0 + 2];
                g.drawImage(img, p.x, p.y, p2.x - p.x, p2.y - p.y, this);
            }
        }
        for (x = this.z12x0 - 1; x <= this.z12x1; ++x) {
            Point p = this.pixelpos[x - this.z12x0 + 1][0];
            if (x % 32 == 0) {
                g.fillRect(p.x - 1, 0, 3, mv.getHeight());
            } else {
                g.drawLine(p.x, 0, p.x, mv.getHeight());
            }
            for (y = this.z12y0 - 1; y <= this.z12y1; ++y) {
                String md;
                int key = (y << 19) + x;
                int texty = p.y + 2 + fontHeight;
                SlippyMapTile tile = this.tileStorage.get(12).get(key);
                p = this.pixelpos[x - this.z12x0 + 1][y - this.z12y0 + 2];
                g.drawString("x=" + x + " y=" + y + " z=12", p.x + 2, texty);
                texty += 1 + fontHeight;
                if (x % 32 == 0 && y % 32 == 0) {
                    g.drawString("x=" + x / 32 + " y=" + y / 32 + " z=7", p.x + 2, texty);
                    texty += 1 + fontHeight;
                }
                if ((md = tile.getMetadata()) != null) {
                    g.drawString(md, p.x + 2, texty);
                    texty += 1 + fontHeight;
                }
                if (tile.getImage() == null) {
                    g.drawString("image not loaded", p.x + 2, texty);
                    texty += 1 + fontHeight;
                }
                if (x != this.z12x0 - 1) continue;
                if (y % 32 == 31) {
                    g.fillRect(0, p.y - 1, mv.getWidth(), 3);
                    continue;
                }
                g.drawLine(0, p.y, mv.getWidth(), p.y);
            }
        }
        oldg.drawImage(this.bufferImage, 0, 0, null);
    }

    SlippyMapTile getTileForPixelpos(int px, int py) {
        int tilex = this.z12x1;
        int tiley = this.z12y1;
        for (int x = this.z12x0; x <= this.z12x1; ++x) {
            if (this.pixelpos[x - this.z12x0 + 1][0].x <= px) continue;
            tilex = x - 1;
            break;
        }
        if (tilex == -1) {
            return null;
        }
        for (int y = this.z12y0; y <= this.z12y1; ++y) {
            if (this.pixelpos[0][y - this.z12y0 + 1].y <= py) continue;
            tiley = y - 1;
            break;
        }
        if (tiley == -1) {
            return null;
        }
        int key = (tiley << 19) + tilex;
        SlippyMapTile tile = this.tileStorage.get(12).get(key);
        if (tile == null) {
            tile = new SlippyMapTile(tilex, tiley, 12);
            this.tileStorage.get(12).put(key, tile);
        }
        return tile;
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"slippymap");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new RenameLayerAction(this.associatedFile, (Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private int latToTileY(double lat) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)(2048.0 * (Math.PI - pf) / Math.PI);
    }

    private int lonToTileX(double lon) {
        return (int)(512.0 * (lon + 180.0) / 45.0);
    }

    private double tileYToLat(int y) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / 2048.0)) * 180.0 / Math.PI;
    }

    private double tileXToLon(int x) {
        return (double)x * 45.0 / 512.0 - 180.0;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done = (infoflags & 0x70) != 0;
        this.needRedraw = true;
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    public void preferenceChanged(String key, String newValue) {
        if (key.startsWith(SlippyMapPreferences.PREFERENCE_PREFIX)) {
            System.err.println(this + ".preferenceChanged('" + key + "', '" + newValue + "') called");
            this.clearTileStorage();
        }
    }

    public void destroy() {
        Main.pref.listener.remove(this);
    }
}

