/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.plugins.ywms.RequestProcessor;

public class HTTPServer
extends Thread {
    public static final int DEFAULT_PORT = 8000;
    private ServerSocket server;

    public HTTPServer(int port) throws IOException {
        super("YWMS HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(port, 1, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
    }

    public void run() {
        System.out.println("YWMS::Accepting connections on port " + this.server.getLocalPort());
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    RequestProcessor.processRequest(request);
                }
            }
            catch (SocketException se) {
                if (this.server.isClosed()) continue;
                se.printStackTrace();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        this.server.close();
    }
}

