/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class SelfIntersectingWay
extends Test {
    public SelfIntersectingWay() {
        super(I18n.tr((String)"Self-intersecting ways"), I18n.tr((String)"This test checks for ways that contain some of their nodes more than once"));
    }

    public void visit(Way w) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (int i = 1; i < w.nodes.size() - 1; ++i) {
            Node n = (Node)w.nodes.get(i);
            if (nodes.contains(n)) {
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Self-intersecting ways"), (OsmPrimitive)w, 0));
                break;
            }
            nodes.add(n);
        }
    }
}

