/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.asm.shaded.AnnotationVisitor;
import org.codehaus.mojo.animal_sniffer.asm.shaded.ClassReader;
import org.codehaus.mojo.animal_sniffer.asm.shaded.ClassVisitor;
import org.codehaus.mojo.animal_sniffer.asm.shaded.MethodVisitor;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;

public class SignatureChecker
extends ClassFileVisitor {
    private final Map classes = new HashMap();
    private final Logger logger;
    private final List ignoredPackageRules;
    private final Set ignoredPackages = new HashSet();
    private boolean hadError = false;

    public static void main(String[] args) throws Exception {
        HashSet<String> ignoredPackages = new HashSet<String>();
        ignoredPackages.add("org.jvnet.animal_sniffer.*");
        ignoredPackages.add("org.codehaus.mojo.animal_sniffer.*");
        ignoredPackages.add("org.objectweb.*");
        new SignatureChecker(new FileInputStream("signature"), ignoredPackages, new PrintWriterLogger(System.out)).process(new File("target/classes"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureChecker(InputStream in, Set ignoredPackages, Logger logger) throws IOException {
        this.ignoredPackageRules = new LinkedList();
        Iterator i = ignoredPackages.iterator();
        while (i.hasNext()) {
            String wildcard = (String)i.next();
            if (wildcard.indexOf(42) == -1 && wildcard.indexOf(63) == -1) {
                this.ignoredPackages.add(wildcard.replace('.', '/'));
                continue;
            }
            this.ignoredPackageRules.add(this.newMatchRule(wildcard.replace('.', '/')));
        }
        this.logger = logger;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new GZIPInputStream(in));
            while (true) {
                Clazz c;
                if ((c = (Clazz)ois.readObject()) == null) {
                    return;
                }
                this.classes.put(c.getName(), c);
                continue;
                break;
            }
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void process(String name, InputStream image) throws IOException {
        ClassReader cr = new ClassReader(image);
        try {
            cr.accept(new CheckingVisitor(name), 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Bad class file " + name);
            IOException ioException = new IOException("Bad class file " + name);
            ioException.initCause(e);
            throw ioException;
        }
    }

    private MatchRule newMatchRule(String matcher) {
        int i = matcher.indexOf(42);
        if (i == -1) {
            return new ExactMatchRule(matcher);
        }
        if (i == matcher.length() - 1) {
            return new PrefixMatchRule(matcher.substring(0, i));
        }
        return new RegexMatchRule(RegexUtils.compileWildcard(matcher));
    }

    public boolean isSignatureBroken() {
        return this.hadError;
    }

    private class CheckingVisitor
    extends ClassVisitor {
        private final Set ignoredPackageCache;
        private final Set warned;
        private final String name;

        public CheckingVisitor(String name) {
            super(262144);
            this.ignoredPackageCache = new HashSet(50 * SignatureChecker.this.ignoredPackageRules.size());
            this.warned = new HashSet();
            this.name = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(262144){
                boolean ignoreError;
                {
                    this.ignoreError = false;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (desc.equals("Lorg/jvnet/animal_sniffer/IgnoreJRERequirement;")) {
                        this.ignoreError = true;
                    }
                    if (desc.equals("Lorg/codehaus/mojo/animal_sniffer/IgnoreJRERequirement;")) {
                        this.ignoreError = true;
                    }
                    return super.visitAnnotation(desc, visible);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    this.check(owner, name + desc);
                }

                public void visitTypeInsn(int opcode, String type) {
                    if (this.shouldBeIgnored(type)) {
                        return;
                    }
                    if (type.charAt(0) == '[') {
                        return;
                    }
                    Clazz sigs = (Clazz)SignatureChecker.this.classes.get(type);
                    if (sigs == null) {
                        CheckingVisitor.this.error("Undefined reference: " + type);
                    }
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    this.check(owner, name + '#' + desc);
                }

                private void check(String owner, String sig) {
                    if (this.shouldBeIgnored(owner)) {
                        return;
                    }
                    if (CheckingVisitor.this.find((Clazz)SignatureChecker.this.classes.get(owner), sig)) {
                        return;
                    }
                    CheckingVisitor.this.error("Undefined reference: " + owner + '.' + sig);
                }

                private boolean shouldBeIgnored(String type) {
                    if (this.ignoreError) {
                        return true;
                    }
                    if (type.charAt(0) == '[') {
                        return true;
                    }
                    if (SignatureChecker.this.ignoredPackages.contains(type) || CheckingVisitor.this.ignoredPackageCache.contains(type)) {
                        return true;
                    }
                    Iterator i = SignatureChecker.this.ignoredPackageRules.iterator();
                    while (i.hasNext()) {
                        MatchRule rule = (MatchRule)i.next();
                        if (!rule.matches(type)) continue;
                        CheckingVisitor.this.ignoredPackageCache.add(type);
                        return true;
                    }
                    return false;
                }
            };
        }

        private boolean find(Clazz c, String sig) {
            if (c == null) {
                return false;
            }
            if (c.getSignatures().contains(sig)) {
                return true;
            }
            if (sig.startsWith("<")) {
                return false;
            }
            if (this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperClass()), sig)) {
                return true;
            }
            if (c.getSuperInterfaces() != null) {
                for (int i = 0; i < c.getSuperInterfaces().length; ++i) {
                    if (!this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperInterfaces()[i]), sig)) continue;
                    return true;
                }
            }
            return false;
        }

        private void error(String msg) {
            SignatureChecker.this.hadError = true;
            if (this.warned.add(msg)) {
                SignatureChecker.this.logger.error(msg + " in " + this.name);
            }
        }
    }

    private static class RegexMatchRule
    implements MatchRule {
        private final Pattern regex;

        public RegexMatchRule(Pattern regex) {
            this.regex = regex;
        }

        public boolean matches(String text) {
            return this.regex.matcher(text).matches();
        }
    }

    private static class ExactMatchRule
    implements MatchRule {
        private final String match;

        public ExactMatchRule(String match) {
            this.match = match;
        }

        public boolean matches(String text) {
            return this.match.equals(text);
        }
    }

    private static class PrefixMatchRule
    implements MatchRule {
        private final String prefix;

        public PrefixMatchRule(String prefix) {
            this.prefix = prefix;
        }

        public boolean matches(String text) {
            return text.startsWith(this.prefix);
        }
    }

    private static interface MatchRule {
        public boolean matches(String var1);
    }
}

