/*
 * Decompiled with CFR 0.152.
 */
package slippymap;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SlippyMapTile {
    private Image tileImage;
    int x;
    int y;
    int z;
    private String metadata;

    public SlippyMapTile(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void loadImage() {
        try {
            this.tileImage = Toolkit.getDefaultToolkit().createImage(new URL("http://dev.openstreetmap.org/~ojw/Tiles/tile.php/" + this.z + "/" + this.x + "/" + this.y + ".png"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public Image getImage() {
        return this.tileImage;
    }

    public void loadMetadata() {
        try {
            URL uRL = new URL("http://tah.openstreetmap.org/Tiles/info_short.php?x=" + this.x + "&y=" + this.y + "&z=12/layer=tile");
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            this.metadata = bufferedReader.readLine();
        }
        catch (Exception exception) {
            this.metadata = "error loading metadata";
        }
    }

    public void requestUpdate() {
        try {
            URL uRL = new URL("http://tah.openstreetmap.org/NeedRender?x=" + this.x + "&y=" + this.y + "&priority=1&src=slippymap_plugin");
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            this.metadata = "requested: " + bufferedReader.readLine();
        }
        catch (Exception exception) {
            this.metadata = "error requesting update";
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SlippyMapTile)) {
            return false;
        }
        SlippyMapTile slippyMapTile = (SlippyMapTile)object;
        return this.x == slippyMapTile.x && this.y == slippyMapTile.y && this.z == slippyMapTile.z;
    }
}

