/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import livegps.LiveGpsAcquirer;
import livegps.LiveGpsDialog;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.RawGpsLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsPlugin
extends Plugin {
    private LiveGpsAcquirer acquirer = null;
    private Thread acquirerThread = null;
    private JMenu lgpsmenu;
    private JCheckBoxMenuItem lgpscapture;
    private JMenuItem lgpscenter;
    private JCheckBoxMenuItem lgpsautocenter;
    private LiveGpsDialog lgpsdialog;
    List<PropertyChangeListener> listenerQueue;
    private Collection<Collection<RawGpsLayer.GpsPoint>> data = new ArrayList<Collection<RawGpsLayer.GpsPoint>>();
    private LiveGpsLayer lgpslayer;

    public LiveGpsPlugin() {
        MainMenu menu = Main.main.menu;
        this.lgpsmenu = new JMenu("LiveGPS");
        this.lgpsmenu.setMnemonic(71);
        menu.add((Component)this.lgpsmenu, 2);
        this.lgpscapture = new JCheckBoxMenuItem(I18n.tr((String)"Capture GPS Track"));
        this.lgpscapture.setSelected(false);
        this.lgpscapture.setAccelerator(KeyStroke.getKeyStroke("alt R"));
        this.lgpscapture.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LiveGpsPlugin.this.enableTracking(LiveGpsPlugin.this.lgpscapture.isSelected());
            }
        });
        this.lgpsmenu.add(this.lgpscapture);
        this.lgpscenter = new JMenuItem(I18n.tr((String)"Center Once"), 67);
        this.lgpscenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (LiveGpsPlugin.this.lgpslayer != null) {
                    LiveGpsPlugin.this.lgpslayer.center();
                }
            }
        });
        this.lgpsmenu.add(this.lgpscenter);
        this.lgpsautocenter = new JCheckBoxMenuItem(I18n.tr((String)"Auto-Center on current position"));
        this.lgpsautocenter.setSelected(true);
        this.lgpsautocenter.setAccelerator(KeyStroke.getKeyStroke(36, 0));
        this.lgpsautocenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LiveGpsPlugin.this.setAutoCenter(LiveGpsPlugin.this.lgpsautocenter.isSelected());
            }
        });
        this.lgpsmenu.add(this.lgpsautocenter);
    }

    public void setAutoCenter(boolean autoCenter) {
        this.lgpsautocenter.setSelected(autoCenter);
        if (this.lgpslayer != null) {
            this.lgpslayer.setAutoCenter(autoCenter);
            if (autoCenter) {
                this.lgpslayer.center();
            }
        }
    }

    public boolean isAutoCenter() {
        return this.lgpsautocenter.isSelected();
    }

    public void enableTracking(boolean enable) {
        if (this.acquirer != null && !enable) {
            this.acquirer.shutdown();
            this.acquirerThread = null;
        } else if (enable) {
            if (this.acquirer == null) {
                this.acquirer = new LiveGpsAcquirer();
                if (this.lgpslayer == null) {
                    this.lgpslayer = new LiveGpsLayer(this.data);
                    Main.main.addLayer((Layer)this.lgpslayer);
                    this.lgpslayer.setAutoCenter(this.isAutoCenter());
                }
                this.addPropertyChangeListener(this.lgpslayer);
                if (this.listenerQueue != null) {
                    for (PropertyChangeListener listener : this.listenerQueue) {
                        this.addPropertyChangeListener(listener);
                    }
                    this.listenerQueue.clear();
                }
            }
            if (this.acquirerThread == null) {
                this.acquirerThread = new Thread(this.acquirer);
                this.acquirerThread.start();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.acquirer != null) {
            this.acquirer.addPropertyChangeListener(listener);
        } else {
            if (this.listenerQueue == null) {
                this.listenerQueue = new ArrayList<PropertyChangeListener>();
            }
            this.listenerQueue.add(listener);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.lgpsdialog = new LiveGpsDialog(newFrame);
            newFrame.addToggleDialog((ToggleDialog)this.lgpsdialog);
            this.addPropertyChangeListener(this.lgpsdialog);
        }
    }

    public JMenu getLgpsMenu() {
        return this.lgpsmenu;
    }
}

