/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.io.ProgressInputStream;

public class WMSImage {
    String constURL;
    protected Image theImage;
    protected double grabbedScale;
    protected EastNorth topLeft;
    protected EastNorth bottomRight;
    double dEast;
    double dNorth;

    public WMSImage(String constURL) {
        this.constURL = constURL;
    }

    public void grab(NavigatableComponent nc) throws IOException {
        EastNorth topLeft = nc.getEastNorth(0, 0);
        this.grabbedScale = nc.getScale();
        this.topLeft = topLeft;
        try {
            URL url = this.getURL(nc);
            this.doGrab(url);
        }
        catch (MalformedURLException e) {
            System.out.println("Illegal url. Error=" + e);
        }
    }

    public void grab(NavigatableComponent nc, double minlat, double minlon, double maxlat, double maxlon) throws IOException {
        LatLon p = new LatLon(minlat, minlon);
        LatLon p2 = new LatLon(maxlat, maxlon);
        this.grabbedScale = nc.getScale();
        this.topLeft = Main.proj.latlon2eastNorth(new LatLon(maxlat, minlon));
        this.bottomRight = Main.proj.latlon2eastNorth(new LatLon(minlat, maxlon));
        int widthPx = (int)((this.bottomRight.east() - this.topLeft.east()) / this.grabbedScale);
        int heightPx = (int)((this.topLeft.north() - this.bottomRight.north()) / this.grabbedScale);
        try {
            URL url = this.doGetURL(p.lon(), p.lat(), p2.lon(), p2.lat(), widthPx, heightPx);
            this.doGrab(url);
        }
        catch (MalformedURLException e) {
            System.out.println("Illegal url. Error=" + e);
        }
    }

    private URL getURL(NavigatableComponent nc) throws MalformedURLException {
        double widthEN = (double)nc.getWidth() * this.grabbedScale;
        double heightEN = (double)nc.getHeight() * this.grabbedScale;
        LatLon p = Main.proj.eastNorth2latlon(new EastNorth(this.topLeft.east(), this.topLeft.north() - heightEN));
        LatLon p2 = Main.proj.eastNorth2latlon(new EastNorth(this.topLeft.east() + widthEN, this.topLeft.north()));
        return this.doGetURL(p.lon(), p.lat(), p2.lon(), p2.lat(), (int)(widthEN / this.grabbedScale), (int)(heightEN / this.grabbedScale));
    }

    protected URL doGetURL(double w, double s, double e, double n, int wi, int ht) throws MalformedURLException {
        String str = this.constURL + "&bbox=" + w + "," + s + "," + e + "," + n + "&width=" + wi + "&height=" + ht;
        return new URL(str.replace(" ", "%20"));
    }

    protected void doGrab(URL url) throws IOException {
        ProgressInputStream is = new ProgressInputStream(url.openConnection(), Main.pleaseWaitDlg);
        this.theImage = ImageIO.read((InputStream)is);
        is.close();
        Main.map.repaint();
    }

    public void displace(double dEast, double dNorth) {
        this.dEast += dEast;
        this.dNorth += dNorth;
    }

    public boolean contains(EastNorth eastNorth) {
        double e1 = this.topLeft.east() + this.dEast;
        double e2 = this.bottomRight.east() + this.dEast;
        double n1 = this.bottomRight.north() + this.dNorth;
        double n2 = this.topLeft.north() + this.dNorth;
        boolean b = eastNorth.east() >= e1 && eastNorth.east() <= e2 && eastNorth.north() >= n1 && eastNorth.north() <= n2;
        return b;
    }

    public void paint(Graphics g, NavigatableComponent nc) {
        if (this.theImage != null) {
            double zoomInFactor = this.grabbedScale / nc.getScale();
            int w = this.theImage.getWidth(null);
            int h = this.theImage.getHeight(null);
            EastNorth topLeftDisplaced = new EastNorth(this.topLeft.east() + this.dEast, this.topLeft.north() + this.dNorth);
            Point displacement = Main.map.mapView.getPoint(topLeftDisplaced);
            g.drawImage(this.theImage, displacement.x, displacement.y, (int)((double)displacement.x + (double)w * zoomInFactor), (int)((double)displacement.y + (double)h * zoomInFactor), 0, 0, w, h, null);
        }
    }
}

