/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OsmarenderPlugin
extends Plugin {
    private JMenu view;
    private JMenuItem osmarenderMenu = new JMenuItem(new Action());

    public OsmarenderPlugin() throws IOException {
        MainMenu menu = Main.main.menu;
        this.view = null;
        for (int i = 0; i < menu.getMenuCount(); ++i) {
            if (menu.getMenu(i) == null || !I18n.tr((String)"View").equals(menu.getMenu(i).getText())) continue;
            this.view = menu.getMenu(i);
            break;
        }
        if (this.view == null) {
            this.view = new JMenu(I18n.tr((String)"View"));
            menu.add((Component)this.view, 2);
            this.view.setVisible(false);
        }
        this.view.add(this.osmarenderMenu);
        this.osmarenderMenu.setVisible(false);
        this.copy("/osmarender.xsl", "osmarender.xsl");
        this.copy("/osm-map-features.xml", "osm-map-features.xml");
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null && newFrame == null) {
            this.osmarenderMenu.setVisible(false);
            if (this.view.getMenuComponentCount() == 1) {
                this.view.setVisible(false);
            }
        } else if (oldFrame == null && newFrame != null) {
            this.osmarenderMenu.setVisible(true);
            if (this.view.getMenuComponentCount() == 1) {
                this.view.setVisible(true);
            }
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new PreferenceSetting(){
            private JTextField firefox = new JTextField(10);

            public void addGui(PreferenceDialog gui) {
                gui.map.add((Component)new JLabel(I18n.tr((String)"osmarender options")), GBC.eol().insets(0, 5, 0, 0));
                gui.map.add((Component)new JLabel(I18n.tr((String)"FireFox executable")), GBC.std().insets(10, 5, 5, 0));
                gui.map.add((Component)this.firefox, GBC.eol().insets(0, 5, 0, 0).fill(2));
                this.firefox.setText(Main.pref.get("osmarender.firefox"));
            }

            public void ok() {
                Main.pref.put("osmarender.firefox", this.firefox.getText());
            }
        };
    }

    private class Action
    extends AbstractAction {
        public Action() {
            super("Osmarender");
        }

        public void actionPerformed(ActionEvent e) {
            LatLon bottomLeft = Main.map.mapView.getLatLon(0, Main.map.mapView.getHeight());
            LatLon topRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), 0);
            Bounds b = new Bounds(bottomLeft, topRight);
            CollectBackReferencesVisitor backRefsV = new CollectBackReferencesVisitor(Main.ds, true);
            DataSet fromDataSet = new DataSet();
            for (Node n : Main.ds.nodes) {
                if (!n.coor.isWithin(b)) continue;
                fromDataSet.nodes.add(n);
                n.visit((Visitor)backRefsV);
            }
            for (OsmPrimitive p : new HashSet(backRefsV.data)) {
                if (!(p instanceof Way)) continue;
                backRefsV.data.addAll(((Way)p).nodes);
            }
            for (OsmPrimitive p : backRefsV.data) {
                fromDataSet.addPrimitive(p);
            }
            String firefox = Main.pref.get("osmarender.firefox", "firefox");
            try {
                OsmWriter.output((OutputStream)new FileOutputStream(OsmarenderPlugin.this.getPluginDir() + "data.osm"), (XmlWriter.OsmWriterInterface)new OsmWriter.All(fromDataSet, true));
                String exec = firefox;
                exec = System.getProperty("os.name").startsWith("Windows") ? exec + " file:///" + OsmarenderPlugin.this.getPluginDir().replace('\\', '/').replace(" ", "%20") + "osm-map-features.xml\"" : exec + " " + OsmarenderPlugin.this.getPluginDir() + "osm-map-features.xml";
                Runtime.getRuntime().exec(exec);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"FireFox not found. Please set firefox executable in the preferences."));
            }
        }
    }
}

