/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferenceEditor
implements PreferenceSetting {
    public static final String PREFIX = "validator";
    public static final String PREF_DEBUG = "validator.debug";
    public static final String PREF_TESTS = "validator.tests";
    public static final String PREF_TESTS_BEFORE_UPLOAD = "validator.testsBeforeUpload";
    private Collection<Test> allTests;

    public void addGui(PreferenceDialog gui) {
        JPanel testPanel = new JPanel(new GridBagLayout());
        testPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        testPanel.add((Component)new JLabel(), GBC.std());
        testPanel.add((Component)new JLabel("On upload"), GBC.eop());
        this.allTests = OSMValidatorPlugin.getAllTests();
        for (Test test : this.allTests) {
            test.addGui(testPanel);
            test.setGuiEnabled(test.enabled || test.testBeforeUpload);
        }
        JScrollPane testPane = new JScrollPane(testPanel, 20, 30);
        testPane.setBorder(null);
        Util.Version ver = Util.getVersion();
        String description = I18n.tr((String)"A OSM data validator that checks for common errors made by users and editor programs.");
        if (ver != null) {
            description = description + "<br><br>" + I18n.tr((String)"Version: {0}<br>Last change at {1}", (Object[])new Object[]{ver.revision, ver.time});
        }
        JPanel tab = gui.createPreferenceTab(PREFIX, I18n.tr((String)"Data validator"), description);
        tab.add((Component)testPane, GBC.eol().fill(1));
        tab.add(GBC.glue((int)0, (int)10), GBC.eol());
    }

    public void ok() {
        StringBuilder tests = new StringBuilder();
        StringBuilder testsBeforeUpload = new StringBuilder();
        for (Test test : this.allTests) {
            test.ok();
            String name = test.getClass().getSimpleName();
            tests.append(',').append(name).append('=').append(test.enabled);
            testsBeforeUpload.append(',').append(name).append('=').append(test.testBeforeUpload);
        }
        if (tests.length() > 0) {
            tests = tests.deleteCharAt(0);
        }
        if (testsBeforeUpload.length() > 0) {
            testsBeforeUpload = testsBeforeUpload.deleteCharAt(0);
        }
        OSMValidatorPlugin.getPlugin().initializeTests(this.allTests);
        Main.pref.put(PREF_TESTS, tests.toString());
        Main.pref.put(PREF_TESTS_BEFORE_UPLOAD, testsBeforeUpload.toString());
    }

    public static void importOldPreferences() {
        if (!Main.pref.hasKey("tests") || !Pattern.matches("(\\w+=(true|false),?)*", Main.pref.get("tests"))) {
            return;
        }
        String enabledTests = Main.pref.get("tests");
        Main.pref.put(PREF_TESTS, enabledTests);
        Main.pref.put("tests", null);
        StringBuilder testsBeforeUpload = new StringBuilder();
        Map oldPrefs = Main.pref.getAllPrefix("tests");
        for (Map.Entry pref : oldPrefs.entrySet()) {
            String key = (String)pref.getKey();
            String value = (String)pref.getValue();
            if (key.endsWith(".checkBeforeUpload")) {
                String testName = key.substring(6, key.length() - 18);
                testsBeforeUpload.append(',').append(testName).append('=').append(value);
            } else {
                Main.pref.put(PREFIX + key.substring(5), value);
            }
            Main.pref.put(key, null);
        }
        if (testsBeforeUpload.length() > 0) {
            testsBeforeUpload = testsBeforeUpload.deleteCharAt(0);
        }
        Main.pref.put(PREF_TESTS_BEFORE_UPLOAD, testsBeforeUpload.toString());
    }
}

