/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.WMSImage;
import wmsplugin.WMSPlugin;

public class WMSLayer
extends Layer {
    protected static Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms.png")));
    protected final ArrayList<WMSImage> wmsImages;
    protected final String url;

    public WMSLayer(String name, String url) {
        super(name);
        this.url = url;
        this.wmsImages = new ArrayList();
    }

    public void grab() throws IOException {
        MapView mv = Main.map.mapView;
        WMSImage wmsImage = new WMSImage(this.url);
        wmsImage.grab((NavigatableComponent)mv);
        this.wmsImages.add(wmsImage);
    }

    public void grab(double minlat, double minlon, double maxlat, double maxlon) throws IOException {
        MapView mv = Main.map.mapView;
        WMSImage wmsImage = new WMSImage(this.url);
        wmsImage.grab((NavigatableComponent)mv, minlat, minlon, maxlat, maxlon);
        this.wmsImages.add(wmsImage);
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        return I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.name, this.wmsImages.size()});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics g, MapView mv) {
        for (WMSImage wmsImage : this.wmsImages) {
            wmsImage.paint(g, (NavigatableComponent)mv);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public WMSImage findImage(EastNorth eastNorth) {
        for (WMSImage wmsImage : this.wmsImages) {
            if (!wmsImage.contains(eastNorth)) continue;
            return wmsImage;
        }
        return null;
    }

    public void destroy() {
        this.wmsImages.clear();
    }
}

