/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.AutoSaveEditLayerTimerTask;
import at.dallermassl.josm.plugin.surveyor.AutoSaveGpsAndMarkerLayerTimeTask;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;

public class AutoSaveAction
extends AbstractAction {
    private static final long serialVersionUID = -8608679323231116043L;
    private static final long AUTO_SAVE_PERIOD_SEC = 60L;
    public static final String GPS_FILE_NAME_PATTERN = "surveyor-{0,date,yyyyMMdd-HHmmss}.gpx";
    public static final String OSM_FILE_NAME_PATTERN = "surveyor-{0,date,yyyyMMdd-HHmmss}.osm";
    private boolean autoSave = false;
    private Timer gpsDataTimer;

    public AutoSaveAction(String name) {
        super(name);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            this.autoSave = ((AbstractButton)e.getSource()).isSelected();
        }
        if (this.autoSave) {
            if (this.gpsDataTimer == null) {
                this.gpsDataTimer = new Timer();
            }
            String gpxFilename = MessageFormat.format(GPS_FILE_NAME_PATTERN, new Date());
            TimerTask task = new AutoSaveGpsAndMarkerLayerTimeTask(gpxFilename, "LiveGPS layer", "surveyorwaypointlayer");
            this.gpsDataTimer.schedule(task, 1000L, 60000L);
            String osmFilename = MessageFormat.format(OSM_FILE_NAME_PATTERN, new Date());
            task = new AutoSaveEditLayerTimerTask(osmFilename);
            this.gpsDataTimer.schedule(task, 5000L, 60000L);
        } else if (this.gpsDataTimer != null) {
            this.gpsDataTimer.cancel();
        }
    }
}

