/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHelper {
    private Pattern varPattern = Pattern.compile("\\$\\{(.+?)\\}");
    private Map<String, String> variables = new HashMap<String, String>();

    public void addAll(Map<String, String> values) {
        this.variables.putAll(values);
    }

    public void add(String key, String value) {
        this.variables.put(key, value);
    }

    public String replaceVariables(String value) {
        StringBuilder source = new StringBuilder(value);
        Matcher matcher = this.varPattern.matcher(source);
        int index = 0;
        while (matcher.find(index)) {
            String varName = matcher.group(1);
            String replacement = this.variables.get(varName);
            if (replacement == null) {
                replacement = System.getProperty(varName);
            }
            if (replacement != null) {
                source.replace(matcher.start(), matcher.end(), replacement);
                index = matcher.start();
                continue;
            }
            index += 4;
        }
        return source.toString();
    }

    public static void main(String[] args) {
        VariableHelper helper = new VariableHelper();
        System.out.println(helper.replaceVariables("abc${java.version}cde${os.name}${user.name}xx${unknoqn}"));
    }
}

