/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.PluginDescription;
import at.dallermassl.josm.plugin.pluginmanager.PluginResource;
import at.dallermassl.josm.plugin.pluginmanager.SiteDescription;
import at.dallermassl.josm.plugin.pluginmanager.VariableHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.co.wilson.xml.MinML2;

public class SiteDescriptionParser
extends MinML2 {
    private SiteDescription siteDescription;
    private PluginDescription pluginDescription;
    private StringBuilder characters;
    private VariableHelper variableHelper;

    public SiteDescriptionParser() {
        this(new SiteDescription());
    }

    public SiteDescriptionParser(SiteDescription siteDescription) {
        this.siteDescription = siteDescription;
    }

    public SiteDescription getSiteDescription() {
        return this.siteDescription;
    }

    public VariableHelper getVariableHelper() {
        return this.variableHelper;
    }

    public void setVariableHelper(VariableHelper variableHelper) {
        this.variableHelper = variableHelper;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("site-name".equals(qName)) {
            this.siteDescription.setName(qName);
        } else if ("plugin".equals(qName)) {
            this.pluginDescription = new PluginDescription();
            this.pluginDescription.setId(atts.getValue("id"));
            this.pluginDescription.setVersion(atts.getValue("version"));
        } else if ("resource".equals(qName)) {
            PluginResource resource = new PluginResource();
            try {
                resource.setResourceUrl(new URL(atts.getValue("src")));
                String target = atts.getValue("target");
                if (this.variableHelper != null) {
                    target = this.variableHelper.replaceVariables(target);
                }
                resource.setTarget(target);
                if (this.pluginDescription == null) {
                    throw new SAXException("Resource was defined outside 'plugin' element!");
                }
                this.pluginDescription.addPluginResource(resource);
            }
            catch (MalformedURLException e) {
                throw new SAXException(e);
            }
        } else if ("site".equals(qName)) {
            if (atts.getIndex("ref") >= 0) {
                String urlString = atts.getValue("ref");
                System.out.println("Handling referenced site " + urlString);
                try {
                    SiteDescription subsite = new SiteDescription(urlString);
                    subsite.loadFromUrl();
                    for (PluginDescription desc : subsite.getPlugins()) {
                        this.siteDescription.addPlugin(desc);
                        System.out.println("adding plugin " + desc.getName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (!"1.0".equals(atts.getValue("version"))) {
                throw new SAXException("Unknown version of site description (must be '1.0')!");
            }
        } else if (!("site-info".equals(qName) || "site-url".equals(qName) || "site-name".equals(qName) || "plugins".equals(qName) || "name".equals(qName) || "description".equals(qName) || "resources".equals(qName) || "sites".equals(qName))) {
            System.err.println("unknown tag: " + qName);
        }
    }

    public void characters(char[] data, int start, int length) throws SAXException {
        if (this.characters == null) {
            this.characters = new StringBuilder();
        }
        this.characters.append(data, start, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("site-name".equals(qName)) {
            this.siteDescription.setName(this.clearCharacters());
            return;
        } else if ("site-url".equals(qName)) {
            try {
                this.siteDescription.setUrl(new URL(this.clearCharacters()));
                return;
            }
            catch (MalformedURLException e) {
                throw new SAXException(e);
            }
        } else if ("name".equals(qName)) {
            if (this.pluginDescription == null) throw new SAXException("'" + qName + "' element is not inside 'plugin' element!");
            this.pluginDescription.setName(this.clearCharacters());
            return;
        } else if ("description".equals(qName)) {
            if (this.pluginDescription == null) throw new SAXException("'" + qName + "' element is not inside 'plugin' element!");
            this.pluginDescription.setDescription(this.clearCharacters());
            return;
        } else {
            if (!"plugin".equals(qName)) return;
            this.siteDescription.addPlugin(this.pluginDescription);
            this.pluginDescription = null;
        }
    }

    private String clearCharacters() {
        String chars = this.characters.toString();
        this.characters = new StringBuilder();
        return chars;
    }
}

