/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.navigator;

import at.dallermassl.josm.plugin.navigator.OsmGraphCreator;
import at.dallermassl.josm.plugin.navigator.PathDescription;
import at.dallermassl.josm.plugin.navigator.SegmentEdge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorModel {
    private Graph<Node, SegmentEdge> graph;
    private List<Node> nodes = new ArrayList<Node>();
    private List<Segment> segmentPath;
    private List<SegmentEdge> edgePath;
    private Map<String, Double> highwayWeight = new HashMap<String, Double>();

    public void setHighwayTypeWeight(String type, double weigth) {
        this.highwayWeight.put(type, weigth);
    }

    public List<Node> getSelectedNodes() {
        return this.nodes;
    }

    public Graph<Node, SegmentEdge> getGraph() {
        if (this.graph == null) {
            OsmGraphCreator graphCreator = new OsmGraphCreator();
            for (String type : this.highwayWeight.keySet()) {
                graphCreator.setHighwayTypeWeight(type, this.highwayWeight.get(type));
            }
            this.graph = graphCreator.createSegmentGraph();
        }
        return this.graph;
    }

    public void calculateShortesPath() {
        System.out.print("navigate nodes ");
        for (Node node : this.nodes) {
            System.out.print(node.id + ",");
        }
        System.out.println();
        double fullWeight = 0.0;
        ArrayList fullPath = new ArrayList();
        for (int index = 1; index < this.nodes.size(); ++index) {
            DijkstraShortestPath routing = new DijkstraShortestPath(this.getGraph(), (Object)this.nodes.get(index - 1), (Object)this.nodes.get(index));
            List path = routing.getPathEdgeList();
            if (path == null) {
                System.out.println("no path found!");
                return;
            }
            fullPath.addAll(path);
            fullWeight += routing.getPathLength();
        }
        this.edgePath = new ArrayList<SegmentEdge>();
        this.edgePath.addAll(fullPath);
        System.out.println("shortest path found: " + fullPath + "\nweight: " + fullWeight);
        System.out.println(this.getPathDescription());
    }

    public String getPathDescription() {
        List<PathDescription> pathDescriptions = this.getPathDescriptions();
        StringBuilder builder = new StringBuilder();
        for (PathDescription desc : pathDescriptions) {
            builder.append("follow ");
            String tmp = desc.getWay().get("name");
            if (tmp == null) {
                builder.append("unkown street ");
            } else {
                builder.append(tmp).append(" ");
            }
            tmp = desc.getWay().get("highway");
            if (tmp != null) {
                builder.append("(").append(tmp).append(") ");
            }
            builder.append("for ").append((int)desc.getLength()).append(" meters, then\n");
        }
        builder.delete(builder.length() - ", then ".length(), builder.length());
        return builder.toString();
    }

    private List<PathDescription> getPathDescriptions() {
        LinkedList<PathDescription> pathDescriptions = new LinkedList<PathDescription>();
        double length = 0.0;
        Way oldWay = null;
        Way way = null;
        for (int segIndex = 0; segIndex < this.edgePath.size(); ++segIndex) {
            PathDescription description;
            SegmentEdge edge = this.edgePath.get(segIndex);
            way = edge.getWay();
            if (way == null) {
                System.out.println("way is null!");
            }
            length += edge.getLengthInM();
            if (oldWay != null && !way.equals(oldWay)) {
                description = new PathDescription(oldWay, length);
                pathDescriptions.add(description);
                length = 0.0;
            }
            if (segIndex == this.edgePath.size() - 1) {
                description = new PathDescription(way, length);
                pathDescriptions.add(description);
            }
            oldWay = way;
        }
        return pathDescriptions;
    }

    public void resetGraph() {
        this.graph = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Segment> getSegmentPath() {
        if (this.segmentPath == null && this.edgePath != null) {
            List<Segment> list = this.segmentPath = new LinkedList<Segment>();
            synchronized (list) {
                for (SegmentEdge edge : this.edgePath) {
                    this.segmentPath.add(edge.getSegment());
                }
            }
        }
        return this.segmentPath;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public List<SegmentEdge> getEdgePath() {
        return this.edgePath;
    }

    public void reset() {
        this.segmentPath = null;
        this.edgePath = null;
        this.nodes.clear();
    }
}

