/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.I18n;

class MergeNodeWayAction
extends JosmAction {
    public MergeNodeWayAction() {
        super(I18n.tr((String)"Join node to way"), "mergenodeway", I18n.tr((String)"Join a node into the nearest way segments"), 0, 0, true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = Main.ds.getSelected();
        if (sel.size() != 1 || !(sel.iterator().next() instanceof Node)) {
            return;
        }
        Node node = (Node)sel.iterator().next();
        List wss = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node.eastNorth));
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            if (ws.way.nodes.get(ws.lowerIndex) == node || ws.way.nodes.get(ws.lowerIndex + 1) == node) continue;
            is.add(ws.lowerIndex);
        }
        LinkedList<ChangeCommand> cmds = new LinkedList<ChangeCommand>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            Way w = (Way)insertPoint.getKey();
            Way wnew = new Way(w);
            List is = (List)insertPoint.getValue();
            MergeNodeWayAction.pruneSuccsAndReverse(is);
            Iterator i$ = is.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                wnew.nodes.add(i + 1, node);
            }
            cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Join Node and Line"), cmds));
        Main.map.repaint();
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }
}

