/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class GeckoSupport {
    public static Process createProfile(String browserPath, String profile) throws IOException {
        ArrayList<String> cmdParams = new ArrayList<String>();
        cmdParams.add(browserPath);
        cmdParams.add("-CreateProfile");
        cmdParams.add(profile);
        System.out.println("YWMS::Create Firefox profile CMD:" + cmdParams);
        ProcessBuilder builder = new ProcessBuilder(cmdParams);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        return GeckoSupport.startProcess(builder);
    }

    private static Process startProcess(ProcessBuilder builder) throws IOException {
        try {
            return builder.start();
        }
        catch (IOException ioe) {
            throw new IOException(I18n.tr((String)"Could not start browser. Please check that the executable path is correct."));
        }
    }

    public static Process browse(String browserPath, String profile, String url, boolean dump) throws IOException {
        ArrayList<String> cmdParams = new ArrayList<String>();
        cmdParams.add(browserPath);
        if (profile != null && profile.length() != 0) {
            cmdParams.add("-P");
            cmdParams.add(profile);
        }
        cmdParams.add(url);
        System.out.println("YWMS::Browsing URL CMD:" + cmdParams);
        ProcessBuilder builder = new ProcessBuilder(cmdParams);
        Map<String, String> environment = builder.environment();
        environment.put("MOZ_NO_REMOTE", "1");
        if (dump) {
            environment.put("MOZ_FORCE_PAINT_AFTER_ONLOAD", System.getProperty("java.io.tmpdir") + "/ywms");
        }
        return GeckoSupport.startProcess(builder);
    }

    public static Process browse(String url, boolean dump) throws IOException {
        return GeckoSupport.browse(Main.pref.get("ywms.firefox", "firefox"), Main.pref.get("ywms.profile"), url, dump);
    }
}

