/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.OSRef;
import wmsplugin.WMSImage;

public class OSGBImage
extends WMSImage {
    public OSGBImage(String constURL) {
        super(constURL);
    }

    @Override
    public void grab(NavigatableComponent nc, double minlat, double minlon, double maxlat, double maxlon) throws IOException {
        LatLng ll1 = new LatLng(minlat, minlon);
        LatLng ll2 = new LatLng(maxlat, maxlon);
        LatLng ll3 = new LatLng(maxlat, minlon);
        LatLng ll4 = new LatLng(minlat, maxlon);
        ll1.toOSGB36();
        ll2.toOSGB36();
        ll3.toOSGB36();
        ll4.toOSGB36();
        OSRef bottomLeftGR = ll1.toOSRef();
        OSRef topRightGR = ll2.toOSRef();
        OSRef topLeftGR = ll3.toOSRef();
        OSRef bottomRightGR = ll4.toOSRef();
        double w = Math.min(bottomLeftGR.getEasting(), topLeftGR.getEasting());
        double s = Math.min(bottomLeftGR.getNorthing(), bottomRightGR.getNorthing());
        double e = Math.max(bottomRightGR.getEasting(), topRightGR.getEasting());
        double n = Math.max(topLeftGR.getNorthing(), topRightGR.getNorthing());
        LatLng tl2 = new OSRef(w, n).toLatLng();
        LatLng br2 = new OSRef(e, s).toLatLng();
        tl2.toWGS84();
        br2.toWGS84();
        this.topLeft = Main.proj.latlon2eastNorth(new LatLon(tl2.getLat(), tl2.getLng()));
        this.bottomRight = Main.proj.latlon2eastNorth(new LatLon(br2.getLat(), br2.getLng()));
        this.grabbedScale = nc.getScale();
        int widthPx = (int)((this.bottomRight.east() - this.topLeft.east()) / this.grabbedScale);
        int heightPx = (int)((this.topLeft.north() - this.bottomRight.north()) / this.grabbedScale);
        try {
            URL url = this.doGetURL(w, s, e, n, widthPx, heightPx);
            this.doGrab(url);
        }
        catch (MalformedURLException ex) {
            System.out.println("Illegal url. Error=" + ex);
        }
    }

    @Override
    public void paint(Graphics g, NavigatableComponent nc) {
        if (this.theImage != null) {
            super.paint(g, nc);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(2.0f));
            double zoomInFactor = this.grabbedScale / nc.getScale();
            EastNorth topLeftDisplaced = new EastNorth(this.topLeft.east() + this.dEast, this.topLeft.north() + this.dNorth);
            EastNorth bottomRightDisplaced = new EastNorth(this.bottomRight.east() + this.dEast, this.bottomRight.north() + this.dNorth);
            LatLon ll5 = Main.proj.eastNorth2latlon(topLeftDisplaced);
            LatLon ll6 = Main.proj.eastNorth2latlon(bottomRightDisplaced);
            LatLng ll7 = new LatLng(ll5.lat(), ll5.lon());
            LatLng ll8 = new LatLng(ll6.lat(), ll6.lon());
            ll7.toOSGB36();
            ll8.toOSGB36();
            OSRef osgb1 = ll7.toOSRef();
            OSRef osgb2 = ll8.toOSRef();
            for (int easting = (int)(osgb1.getEasting() / 1000.0) + 1; easting <= (int)(osgb2.getEasting() / 1000.0); ++easting) {
                for (int northing = (int)(osgb1.getNorthing() / 1000.0); northing > (int)(osgb2.getNorthing() / 1000.0); --northing) {
                    LatLng curLatLng = new OSRef(easting * 1000, northing * 1000).toLatLng();
                    curLatLng.toWGS84();
                    EastNorth curEN = Main.proj.latlon2eastNorth(new LatLon(curLatLng.getLat(), curLatLng.getLng()));
                    Point p = Main.map.mapView.getPoint(curEN);
                    g.setColor(Color.BLUE);
                    g.drawLine(p.x - 5, p.y, p.x + 5, p.y);
                    g.drawLine(p.x, p.y - 5, p.x, p.y + 5);
                }
            }
            g2d.setStroke(new BasicStroke(1.0f));
        }
    }
}

