/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.navigator;

import at.dallermassl.josm.plugin.navigator.JosmEdgeFactory;
import at.dallermassl.josm.plugin.navigator.SegmentEdge;
import at.dallermassl.josm.plugin.navigator.WayEdge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Segment;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmGraphCreator {
    private Map<Node, Set<Segment>> nodeSegmentMap = new HashMap<Node, Set<Segment>>();
    private Set<Segment> segments = new HashSet<Segment>();
    private Set<Way> ways = new HashSet<Way>();
    private Set<Node> crossingNodes = new HashSet<Node>();
    private List<WayEdge> edges = new ArrayList<WayEdge>();
    private Map<String, Double> highwayWeight = new HashMap<String, Double>();
    private static final double DEFAULT_WEIGHT = 0.0;

    public void setHighwayTypeWeight(String type, double weigth) {
        this.highwayWeight.put(type, weigth);
        System.out.println("set " + type + " to " + weigth);
    }

    public Graph<Node, SegmentEdge> createSegmentGraph() {
        DirectedWeightedMultigraph graph = new DirectedWeightedMultigraph(SegmentEdge.class);
        for (Way way : Main.ds.ways) {
            if (way == null || way.deleted) continue;
            for (Segment segment : way.segments) {
                if (segment == null || segment.deleted || segment.from == null || segment.to == null) continue;
                graph.addVertex((Object)segment.from);
                graph.addVertex((Object)segment.to);
                SegmentEdge edge = new SegmentEdge(segment);
                edge.setWay(way);
                graph.addEdge((Object)segment.from, (Object)segment.to, (Object)edge);
                double weight = this.getWeight(way, segment);
                System.out.println("edge for segment " + segment.id + "(from node " + segment.from.id + " to node " + segment.to.id + ") has weight: " + weight);
                graph.setEdgeWeight((Object)edge, weight);
                if (this.isOneWay(way)) continue;
                edge = new SegmentEdge(segment, true);
                edge.setWay(way);
                graph.addEdge((Object)segment.to, (Object)segment.from, (Object)edge);
                graph.setEdgeWeight((Object)edge, weight);
                System.out.println("inverse segment " + segment.id + "(from node " + segment.to.id + " to node " + segment.from.id + ") has weight: " + weight);
            }
        }
        return graph;
    }

    public double getWeight(Way way, Segment segment) {
        String type = way.get("highway");
        if (type == null) {
            return Double.MAX_VALUE;
        }
        Double weightValue = this.highwayWeight.get(type);
        double weight = weightValue == null ? 0.0 : weightValue;
        double distance = Math.sqrt(segment.from.coor.distance((Coordinate)segment.to.coor)) * 111000.0;
        if (weight == 0.0) {
            weight = 1.0E-20;
        }
        return distance / weight;
    }

    public boolean isOneWay(Way way) {
        return way.get("oneway") != null || "motorway".equals(way.get("highway"));
    }

    public Graph<Node, WayEdge> createGraph() {
        this.createEdges();
        DirectedWeightedMultigraph graph = new DirectedWeightedMultigraph((EdgeFactory)new JosmEdgeFactory());
        for (WayEdge edge : this.edges) {
            graph.addVertex((Object)edge.getStartNode());
            graph.addVertex((Object)edge.getEndNode());
            graph.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode(), (Object)edge);
        }
        return graph;
    }

    private void createEdges() {
        System.out.println("Start free Memory: " + Runtime.getRuntime().freeMemory());
        for (Way way : Main.ds.ways) {
            for (Segment segment : way.segments) {
                this.addSegmentForNode(segment.from, segment);
                this.addSegmentForNode(segment.to, segment);
                this.segments.add(segment);
            }
        }
        System.out.println("after all segments free Memory: " + Runtime.getRuntime().freeMemory());
        for (Node node : this.nodeSegmentMap.keySet()) {
            Set<Segment> nodeSegments = this.nodeSegmentMap.get(node);
            if (nodeSegments.size() != 1 && nodeSegments.size() <= 2) continue;
            this.crossingNodes.add(node);
        }
        System.out.println("after all crossings free Memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Number of Nodes: " + Main.ds.nodes.size());
        System.out.println("Number of Segments: " + Main.ds.segments.size());
        System.out.println("Number of Graph Vertices: " + this.crossingNodes.size());
        System.out.println("Number of Nodes in Segment Map: " + this.nodeSegmentMap.keySet().size());
        Iterator<Node> i$ = this.crossingNodes.iterator();
        while (i$.hasNext()) {
            Node sourceNode;
            Node targetNode = sourceNode = i$.next();
            for (Segment segment : this.nodeSegmentMap.get(sourceNode)) {
                WayEdge edge = new WayEdge();
                ArrayList<Segment> edgeSegments = new ArrayList<Segment>();
                boolean crossingReached = false;
                do {
                    targetNode = this.getOtherEnd(targetNode, segment);
                    edgeSegments.add(segment);
                    if (this.crossingNodes.contains(targetNode)) {
                        crossingReached = true;
                        continue;
                    }
                    segment = this.getOtherSegment(targetNode, segment);
                } while (!crossingReached);
                edge.setSegments(edgeSegments);
                edge.setStartNode(sourceNode);
                edge.setEndNode(targetNode);
                System.out.println("Adding edge with " + edgeSegments.size() + " segments: " + edgeSegments);
                System.out.println("after adding edge free Memory: " + Runtime.getRuntime().freeMemory());
                this.edges.add(edge);
            }
        }
    }

    private Segment getOtherSegment(Node node, Segment segment) {
        Set<Segment> segments = this.nodeSegmentMap.get(node);
        if (segments.size() != 2) {
            throw new RuntimeException("the given node has more than two nodes!");
        }
        if (!segments.contains(segment)) {
            throw new RuntimeException("the given segment is not connected to the given node");
        }
        Iterator<Segment> segIter = segments.iterator();
        Segment next = segIter.next();
        if (segment.equals((Object)next)) {
            return segIter.next();
        }
        return segment;
    }

    private void addSegmentForNode(Node node, Segment segment) {
        Set<Segment> segments = this.nodeSegmentMap.get(node);
        if (segments == null) {
            segments = new HashSet<Segment>();
            this.nodeSegmentMap.put(node, segments);
        }
        if (!segments.contains(segment)) {
            segments.add(segment);
        }
    }

    private Node getOtherEnd(Node node, Segment segment) {
        if (segment.from.equals((Object)node)) {
            return segment.to;
        }
        return segment.from;
    }
}

