/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.navigator;

import at.dallermassl.josm.plugin.navigator.NavigatorAction;
import at.dallermassl.josm.plugin.navigator.NavigatorLayer;
import at.dallermassl.josm.plugin.navigator.NavigatorModeAction;
import at.dallermassl.josm.plugin.navigator.NavigatorModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class NavigatorPlugin
extends Plugin {
    private static final String KEY_HIGHWAY_WEIGHT_PREFIX = "navigator.weight.";
    private NavigatorLayer navigatorLayer;
    private NavigatorModel navigatorModel;

    public NavigatorPlugin() {
        this.checkWeights();
        this.navigatorModel = new NavigatorModel();
        this.setHighwayTypeWeights();
        this.navigatorLayer = new NavigatorLayer(I18n.tr((String)"Navigation"));
        this.navigatorLayer.setNavigatorNodeModel(this.navigatorModel);
        MainMenu menu = Main.main.menu;
        JMenu navigatorMenu = new JMenu(I18n.tr((String)"Navigation"));
        JMenuItem navigatorMenuItem = new JMenuItem(new NavigatorAction(this));
        navigatorMenu.add(navigatorMenuItem);
        JMenuItem resetMenuItem = new JMenuItem(I18n.tr((String)"Reset Graph"));
        resetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPlugin.this.navigatorModel.resetGraph();
                NavigatorPlugin.this.setHighwayTypeWeights();
            }
        });
        navigatorMenu.add(resetMenuItem);
        menu.add(navigatorMenu);
    }

    private void setHighwayTypeWeights() {
        Map weightMap = Main.pref.getAllPrefix(KEY_HIGHWAY_WEIGHT_PREFIX);
        for (String typeKey : weightMap.keySet()) {
            String type = typeKey.substring(KEY_HIGHWAY_WEIGHT_PREFIX.length());
            double weight = Double.parseDouble((String)weightMap.get(typeKey));
            this.navigatorModel.setHighwayTypeWeight(type, weight);
        }
    }

    private void checkWeights() {
        this.setDefaultWeight("motorway", 100.0);
        this.setDefaultWeight("primary", 80.0);
        this.setDefaultWeight("secondary", 70.0);
        this.setDefaultWeight("tertiary", 60.0);
        this.setDefaultWeight("unclassified", 60.0);
        this.setDefaultWeight("residential", 40.0);
        this.setDefaultWeight("pedestrian", 0.0);
        this.setDefaultWeight("cycleway", 0.0);
        this.setDefaultWeight("footway", 0.0);
    }

    private void setDefaultWeight(String type, double value) {
        if (!Main.pref.hasKey(KEY_HIGHWAY_WEIGHT_PREFIX + type)) {
            Main.pref.put(KEY_HIGHWAY_WEIGHT_PREFIX + type, String.valueOf(value));
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            IconToggleButton button = new IconToggleButton((Action)((Object)new NavigatorModeAction(newFrame, this.navigatorModel, this.navigatorLayer)));
            newFrame.toolBarActions.add((Component)button);
            newFrame.toolGroup.add((AbstractButton)button);
        }
    }

    public void navigate() {
        this.navigatorLayer.navigate();
    }
}

