/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor.action;

import at.dallermassl.josm.plugin.surveyor.GpsActionEvent;
import at.dallermassl.josm.plugin.surveyor.SurveyorPlugin;
import at.dallermassl.josm.plugin.surveyor.action.AbstractSurveyorAction;
import at.dallermassl.josm.plugin.surveyor.action.gui.WaypointDialog;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JToggleButton;
import livegps.LiveGpsLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;

public class SetWaypointAction
extends AbstractSurveyorAction {
    private MarkerLayer markerLayer;
    public static final String MARKER_LAYER_NAME = "surveyorwaypointlayer";
    private WaypointDialog dialog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(GpsActionEvent event) {
        LatLon coordinates = event.getCoordinates();
        System.out.println(this.getClass().getSimpleName() + " KOORD: " + coordinates.lat() + ", " + coordinates.lon());
        MarkerLayer layer = this.getGpsLayer();
        String markerTitle = this.getParameters().get(0);
        Object source = event.getSource();
        if (source instanceof JToggleButton) {
            markerTitle = ((JToggleButton)source).isSelected() ? markerTitle + " " + I18n.tr((String)"start") : markerTitle + " " + I18n.tr((String)"end");
        }
        if (this.dialog == null) {
            this.dialog = new WaypointDialog();
        }
        String markerText = markerTitle;
        String inputText = this.dialog.openDialog(SurveyorPlugin.getSurveyorFrame(), "Waypoint Description");
        if (inputText != null && inputText.length() > 0) {
            inputText = inputText.replaceAll("<", "_");
            markerText = markerText + " " + inputText;
        }
        String iconName = this.getParameters().size() > 1 ? this.getParameters().get(1) : null;
        Class<LiveGpsLock> clazz = LiveGpsLock.class;
        synchronized (LiveGpsLock.class) {
            layer.data.add(new Marker(event.getCoordinates(), markerText, iconName));
            // ** MonitorExit[var9_9] (shouldn't be in output)
            Main.map.repaint();
            return;
        }
    }

    public MarkerLayer getGpsLayer() {
        if (this.markerLayer == null) {
            Collection layers = Main.map.mapView.getAllLayers();
            for (Layer layer : layers) {
                if (!MARKER_LAYER_NAME.equals(layer.name)) continue;
                this.markerLayer = (MarkerLayer)layer;
                break;
            }
            if (this.markerLayer == null) {
                this.markerLayer = new MarkerLayer(new ArrayList(), MARKER_LAYER_NAME, null);
                Main.main.addLayer((Layer)this.markerLayer);
            }
        }
        return this.markerLayer;
    }
}

