/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import livegps.LiveGpsLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.RawGpsLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSaveGpsLayerTimerTask
extends TimerTask {
    private String gpsLayerName;
    private File file;

    public AutoSaveGpsLayerTimerTask(String filename, String layerName) {
        this.gpsLayerName = layerName;
        this.file = new File(filename);
    }

    public String getGpsLayerName() {
        return this.gpsLayerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            XmlWriter.OsmWriterInterface writer = this.getXmlWriter();
            if (writer == null) return;
            File tmpFile = new File(this.file.getAbsoluteFile() + ".tmp");
            System.out.println("AutoSaving data to file " + this.file.getAbsolutePath());
            Class<LiveGpsLock> clazz = LiveGpsLock.class;
            synchronized (LiveGpsLock.class) {
                XmlWriter.output((OutputStream)new FileOutputStream(tmpFile), (XmlWriter.OsmWriterInterface)writer);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                tmpFile.renameTo(this.file);
                return;
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while exporting {0}: {1}", (Object[])new Object[]{this.file.getAbsoluteFile(), x.getMessage()}), I18n.tr((String)"Error"), 0);
        }
    }

    public <LayerType extends Layer> LayerType findGpsLayer(String layerName, Class<LayerType> layerType) {
        Layer result = null;
        if (Main.map != null && Main.map.mapView != null) {
            for (Layer layer : Main.map.mapView.getAllLayers()) {
                if (!layerName.equals(layer.name) || !layerType.isAssignableFrom(layer.getClass())) continue;
                result = layer;
                break;
            }
        }
        return (LayerType)result;
    }

    public XmlWriter.OsmWriterInterface getXmlWriter() {
        RawGpsLayer gpsLayer = this.findGpsLayer(this.gpsLayerName, RawGpsLayer.class);
        if (gpsLayer == null) {
            return null;
        }
        return new GpxWriter.Trk(gpsLayer.data);
    }
}

