/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.openvisible;

import at.dallermassl.josm.plugin.openvisible.OsmGpxBounds;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.RawGpsLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.RawCsvReader;
import org.openstreetmap.josm.io.RawGpsReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class OpenVisibleAction
extends JosmAction {
    private File lastDirectory;

    public OpenVisibleAction() {
        super(I18n.tr((String)"Open Visible"), "openvisible", I18n.tr((String)"Open only files that are visible in current view."), 79, 192, true);
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.map == null || Main.map.mapView == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No view open - cannot determine boundaries!"));
            return;
        }
        MapView view = Main.map.mapView;
        Rectangle bounds = view.getBounds();
        LatLon bottomLeft = view.getLatLon(bounds.x, bounds.y + bounds.height);
        LatLon topRight = view.getLatLon(bounds.x + bounds.width, bounds.y);
        System.err.println("FileFind Bounds: " + bottomLeft + " to " + topRight);
        JFileChooser fileChooser = this.lastDirectory != null ? new JFileChooser(this.lastDirectory) : new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.showOpenDialog(Main.parent);
        File[] files = fileChooser.getSelectedFiles();
        this.lastDirectory = fileChooser.getCurrentDirectory();
        for (File file : files) {
            try {
                OsmGpxBounds parser = new OsmGpxBounds();
                parser.parse(new BufferedInputStream(new FileInputStream(file)));
                if (!parser.intersects(bottomLeft.lat(), topRight.lat(), bottomLeft.lon(), topRight.lon())) continue;
                System.out.println(file.getAbsolutePath());
                if (file.getName().endsWith("osm")) {
                    this.openAsData(file);
                    continue;
                }
                if (!file.getName().endsWith("gpx")) continue;
                this.openFileAsRawGps(file);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void openAsData(File file) throws SAXException, IOException, FileNotFoundException {
        String fn = file.getName();
        if (ExtensionFileFilter.filters[0].acceptName(fn)) {
            DataSet dataSet = OsmReader.parseDataSet((InputStream)new FileInputStream(file), null, (PleaseWaitDialog)Main.pleaseWaitDlg);
            OsmDataLayer layer = new OsmDataLayer(dataSet, file.getName(), file);
            Main.main.addLayer((Layer)layer);
        } else if (ExtensionFileFilter.filters[2].acceptName(fn)) {
            JOptionPane.showMessageDialog(Main.parent, fn + ": " + I18n.tr((String)"CSV Data import for non-GPS data is not implemented yet."));
        } else {
            JOptionPane.showMessageDialog(Main.parent, fn + ": " + I18n.tr((String)"Unknown file extension: {0}", (Object[])new Object[]{fn.substring(file.getName().lastIndexOf(46) + 1)}));
        }
    }

    private void openFileAsRawGps(File file) throws SAXException, IOException, FileNotFoundException {
        String fn = file.getName();
        Collection gpsData = null;
        Collection markerData = null;
        if (ExtensionFileFilter.filters[1].acceptName(fn)) {
            RawGpsReader r = null;
            r = file.getName().endsWith(".gpx.gz") ? new RawGpsReader((InputStream)new GZIPInputStream(new FileInputStream(file)), file.getAbsoluteFile().getParentFile()) : new RawGpsReader((InputStream)new FileInputStream(file), file.getAbsoluteFile().getParentFile());
            gpsData = r.trackData;
            markerData = r.markerData;
        } else if (ExtensionFileFilter.filters[2].acceptName(fn)) {
            gpsData = new LinkedList<Collection>();
            gpsData.add(new RawCsvReader((Reader)new FileReader(file)).parse());
        } else {
            throw new IllegalStateException();
        }
        if (gpsData != null && !gpsData.isEmpty()) {
            Main.main.addLayer((Layer)new RawGpsLayer(false, gpsData, I18n.tr((String)"Tracks from {0}", (Object[])new Object[]{file.getName()}), file));
        }
        if (markerData != null && !markerData.isEmpty()) {
            Main.main.addLayer((Layer)new MarkerLayer(markerData, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{file.getName()}), file));
        }
    }
}

