/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.taggingpresettester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.tagging.TaggingCellRenderer;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.xml.sax.SAXException;

public class TaggingPresetTester
extends JFrame {
    private JComboBox taggingPresets;
    private final String[] args;
    private JPanel taggingPresetPanel = new JPanel(new BorderLayout());
    private JPanel panel = new JPanel(new BorderLayout());

    public void reload() {
        Vector vector = new Vector();
        for (String string : this.args) {
            InputStream inputStream = null;
            try {
                inputStream = string.startsWith("http") || string.startsWith("ftp") || string.startsWith("file") ? new URL(string).openStream() : (string.startsWith("resource://") ? TaggingPresetTester.class.getResourceAsStream(string.substring("resource:/".length())) : new FileInputStream(string));
                vector.addAll(TaggingPreset.readAll((InputStream)inputStream));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(null, "Could not read tagging preset source: " + string);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error parsing " + string + ": " + sAXException.getMessage());
            }
            try {
                if (inputStream == null) continue;
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.taggingPresets.setModel(new DefaultComboBoxModel(vector));
    }

    public void reselect() {
        this.taggingPresetPanel.removeAll();
        TaggingPreset taggingPreset = (TaggingPreset)this.taggingPresets.getSelectedItem();
        if (taggingPreset == null) {
            return;
        }
        JPanel jPanel = taggingPreset.createPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (jPanel != null) {
            this.taggingPresetPanel.add((Component)jPanel, "North");
        }
        this.panel.validate();
        this.panel.repaint();
    }

    public TaggingPresetTester(String[] stringArray) {
        super("Tagging Preset Tester");
        this.args = stringArray;
        this.taggingPresets = new JComboBox();
        this.taggingPresets.setRenderer(new TaggingCellRenderer());
        this.reload();
        this.panel.add((Component)this.taggingPresets, "North");
        this.panel.add((Component)this.taggingPresetPanel, "Center");
        this.taggingPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaggingPresetTester.this.reselect();
            }
        });
        this.reselect();
        JButton jButton = new JButton("Reload");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TaggingPresetTester.this.taggingPresets.getSelectedIndex();
                TaggingPresetTester.this.reload();
                TaggingPresetTester.this.taggingPresets.setSelectedIndex(n);
            }
        });
        this.panel.add((Component)jButton, "South");
        this.setContentPane(this.panel);
        this.setSize(300, 500);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        Container container;
        if (stringArray.length == 0) {
            container = new JFileChooser();
            if (((JFileChooser)container).showOpenDialog(null) != 0) {
                return;
            }
            stringArray = new String[]{((JFileChooser)container).getSelectedFile().getPath()};
        }
        container = new TaggingPresetTester(stringArray);
        ((JFrame)container).setDefaultCloseOperation(3);
    }
}

