/*
 * Decompiled with CFR 0.152.
 */
package mappaint;

import java.io.File;
import java.io.FileReader;
import java.net.URL;
import mappaint.ElemStyleHandler;
import mappaint.ElemStyles;
import mappaint.MapPaintVisitor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MapPaintPlugin
extends Plugin
implements MapView.LayerChangeListener {
    public static ElemStyles elemStyles = new ElemStyles();
    public static String styleDir;

    public static String getStyleDir() {
        return styleDir;
    }

    public MapPaintPlugin() {
        String styleName = Main.pref.get("mappaint.style", "standard");
        styleDir = Main.pref.getPreferencesDir() + "plugins/mappaint/" + styleName + "/";
        String elemStylesFile = MapPaintPlugin.getStyleDir() + "elemstyles.xml";
        File f = new File(elemStylesFile);
        if (f.exists()) {
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                ElemStyleHandler handler = new ElemStyleHandler();
                xmlReader.setContentHandler(handler);
                xmlReader.setErrorHandler(handler);
                handler.setElemStyles(elemStyles);
                xmlReader.parse(new InputSource(new FileReader(f)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            URL elemStylesPath = ((Object)((Object)this)).getClass().getResource("/" + styleName + "/elemstyles.xml");
            if (elemStylesPath != null) {
                try {
                    XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                    ElemStyleHandler handler = new ElemStyleHandler();
                    xmlReader.setContentHandler(handler);
                    xmlReader.setErrorHandler(handler);
                    handler.setElemStyles(elemStyles);
                    xmlReader.parse(new InputSource(elemStylesPath.openStream()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                System.out.println("mappaint: Couldn't find style: \"" + styleDir + "elemstyles.xml\"");
            }
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            newFrame.mapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        } else {
            oldFrame.mapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            ((OsmDataLayer)newLayer).setMapPainter((SimplePaintVisitor)new MapPaintVisitor());
        }
    }

    public void layerRemoved(Layer oldLayer) {
    }
}

