/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.I18n;

class MergeNodesAction
extends JosmAction {
    public MergeNodesAction() {
        super(I18n.tr((String)"Merge nodes"), "mergenodes", I18n.tr((String)"Merge nodes"), 0, 0, true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = Main.ds.getSelected();
        HashSet<Node> nodes = new HashSet<Node>();
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Node)) continue;
            nodes.add((Node)osm);
        }
        if (nodes.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Must select at least two nodes."));
            return;
        }
        Node target = null;
        for (Node n : nodes) {
            if (target != null && target.id != 0L && n.id >= target.id) continue;
            target = n;
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        Node newTarget = new Node(target);
        double x = 0.0;
        double y = 0.0;
        for (Node n : nodes) {
            x += n.eastNorth.east();
            y += n.eastNorth.north();
        }
        newTarget.eastNorth = new EastNorth(x / (double)nodes.size(), y / (double)nodes.size());
        cmds.add(new ChangeCommand((OsmPrimitive)target, (OsmPrimitive)newTarget));
        HashSet delNodes = new HashSet(nodes);
        delNodes.remove(target);
        cmds.add(new DeleteCommand(delNodes));
        for (Way w : Main.ds.ways) {
            if (w.deleted || w.incomplete) continue;
            boolean affected = false;
            for (Node n : nodes) {
                if (!w.nodes.contains(n)) continue;
                affected = true;
                break;
            }
            if (!affected) continue;
            Way wnew = new Way(w);
            for (int i = 0; i < wnew.nodes.size(); ++i) {
                if (!nodes.contains(wnew.nodes.get(i))) continue;
                wnew.nodes.set(i, target);
            }
            Node lastN = null;
            for (int i = wnew.nodes.size() - 1; i >= 0; --i) {
                Node n = (Node)wnew.nodes.get(i);
                if (lastN == n) {
                    wnew.nodes.remove(i);
                }
                lastN = n;
            }
            if (wnew.nodes.size() < 2) {
                CollectBackReferencesVisitor backRefV = new CollectBackReferencesVisitor(Main.ds, false);
                backRefV.visit(w);
                if (!backRefV.data.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot merge nodes: Would have to delete a way that is still used."));
                    return;
                }
                cmds.add(new DeleteCommand(Collections.singleton(w)));
                continue;
            }
            cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Merge Nodes"), cmds));
        Main.ds.setSelected(new OsmPrimitive[]{newTarget});
        Main.map.repaint();
    }
}

