/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyWayAction
extends JosmAction {
    public static double EARTH_RAD = 6378137.0;
    public static double radmiles = EARTH_RAD * 100.0 / 2.54 / 12.0 / 5280.0;

    public SimplifyWayAction() {
        super(I18n.tr((String)"Simplify Way"), "simplify", I18n.tr((String)"Delete unnecessary nodes from a way."), 0, 0, true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = Main.ds.getSelected();
        if (selection.size() == 1 && selection.iterator().next() instanceof Way) {
            this.simplifyWay((Way)selection.iterator().next());
        }
    }

    public void simplifyWay(Way w) {
        double threshold = Double.parseDouble(Main.pref.get("simplify-way.max-error", "50"));
        Way wnew = new Way(w);
        int toI = wnew.nodes.size() - 1;
        for (int i = wnew.nodes.size() - 1; i >= 0; --i) {
            CollectBackReferencesVisitor backRefsV = new CollectBackReferencesVisitor(Main.ds, false);
            backRefsV.visit((Node)wnew.nodes.get(i));
            boolean used = false;
            if (backRefsV.data.size() == 1) {
                used = Collections.frequency(w.nodes, wnew.nodes.get(i)) > 1;
            } else {
                backRefsV.data.remove(w);
                boolean bl = used = !backRefsV.data.isEmpty();
            }
            if (!used) continue;
            if (toI - i >= 2) {
                ArrayList<Node> ns = new ArrayList<Node>();
                this.simplifyWayRange(wnew, i, toI, ns, threshold);
                for (int j = toI - 1; j > i; --j) {
                    wnew.nodes.remove(j);
                }
                wnew.nodes.addAll(i + 1, ns);
            }
            toI = i;
        }
        HashSet delNodes = new HashSet();
        delNodes.addAll(w.nodes);
        delNodes.removeAll(wnew.nodes);
        if (wnew.nodes.size() != w.nodes.size()) {
            LinkedList<Object> cmds = new LinkedList<Object>();
            cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
            cmds.add(new DeleteCommand(delNodes));
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Simplify Way (remove {0} nodes)", (Object[])new Object[]{delNodes.size()}), cmds));
            Main.map.repaint();
        }
    }

    public void simplifyWayRange(Way wnew, int from, int to, ArrayList<Node> ns, double thr) {
        Node fromN = (Node)wnew.nodes.get(from);
        Node toN = (Node)wnew.nodes.get(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = (Node)wnew.nodes.get(i);
            double xte = SimplifyWayAction.radtometers(SimplifyWayAction.linedist(fromN.coor.lat(), fromN.coor.lon(), n.coor.lat(), n.coor.lon(), toN.coor.lat(), toN.coor.lon()));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= thr) {
            this.simplifyWayRange(wnew, from, imax, ns, thr);
            ns.add((Node)wnew.nodes.get(imax));
            this.simplifyWayRange(wnew, imax, to, ns, thr);
        }
    }

    public static double[] crossproduct(double[] v1, double[] v2) {
        double[] rv = new double[]{v1[1] * v2[2] - v2[1] * v1[2], v1[2] * v2[0] - v2[2] * v1[0], v1[0] * v2[1] - v1[1] * v2[0]};
        return rv;
    }

    public static double dotproduct(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static double radtomiles(double rads) {
        return rads * radmiles;
    }

    public static double radtometers(double rads) {
        return rads * EARTH_RAD;
    }

    public static double veclen(double[] vec) {
        return Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2]);
    }

    public static double gcdist(double lat1, double lon1, double lat2, double lon2) {
        double sdlat = Math.sin((lat1 - lat2) / 2.0);
        double sdlon = Math.sin((lon1 - lon2) / 2.0);
        double res = Math.sqrt(sdlat * sdlat + Math.cos(lat1) * Math.cos(lat2) * sdlon * sdlon);
        if (res > 1.0) {
            res = 1.0;
        } else if (res < -1.0) {
            res = -1.0;
        }
        res = Math.asin(res);
        return 2.0 * res;
    }

    static double linedist(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        lat3 = Math.toRadians(lat3);
        lon3 = Math.toRadians(lon3);
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] v3 = new double[3];
        v1[0] = Math.cos(lon1) * Math.cos(lat1);
        v1[1] = Math.sin(lat1);
        v1[2] = Math.sin(lon1) * Math.cos(lat1);
        v2[0] = Math.cos(lon2) * Math.cos(lat2);
        v2[1] = Math.sin(lat2);
        v2[2] = Math.sin(lon2) * Math.cos(lat2);
        v3[0] = Math.cos(lon3) * Math.cos(lat3);
        v3[1] = Math.sin(lat3);
        v3[2] = Math.sin(lon3) * Math.cos(lat3);
        double[] va = SimplifyWayAction.crossproduct(v1, v2);
        double la = SimplifyWayAction.veclen(va);
        if (la != 0.0) {
            va[0] = va[0] / la;
            va[1] = va[1] / la;
            va[2] = va[2] / la;
            double dot = SimplifyWayAction.dotproduct(v3, va);
            double[] vp = new double[]{v3[0] - dot * va[0], v3[1] - dot * va[1], v3[2] - dot * va[2]};
            double lp = SimplifyWayAction.veclen(vp);
            if (lp != 0.0) {
                vp[0] = vp[0] / lp;
                vp[1] = vp[1] / lp;
                vp[2] = vp[2] / lp;
                double[] cp1 = SimplifyWayAction.crossproduct(v1, vp);
                double dp1 = SimplifyWayAction.dotproduct(cp1, va);
                double[] cp2 = SimplifyWayAction.crossproduct(v2, vp);
                double dp2 = SimplifyWayAction.dotproduct(cp2, va);
                if (dp1 >= 0.0 && dp2 >= 0.0) {
                    return Math.atan(Math.abs(dot) / lp);
                }
                double c1 = SimplifyWayAction.dotproduct(v1, vp);
                double c2 = SimplifyWayAction.dotproduct(v2, vp);
                dp1 = Math.abs(dp1);
                dp2 = Math.abs(dp2);
                if (c1 < 0.0) {
                    dp1 = 2.0 - dp1;
                }
                if (c2 < 0.0) {
                    dp2 = 2.0 - dp2;
                }
                if (Math.abs(dp1) < Math.abs(dp2)) {
                    return SimplifyWayAction.gcdist(lat1, lon1, lat3, lon3);
                }
                return SimplifyWayAction.gcdist(lat2, lon2, lat3, lon3);
            }
            return 1.5707963267948966;
        }
        double dot = SimplifyWayAction.dotproduct(v1, v2);
        if (dot >= 0.0) {
            return SimplifyWayAction.gcdist(lat1, lon1, lat3, lon3);
        }
        return 0.0;
    }
}

