/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.ErrorTreePanel;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidateUploadHook
implements UploadAction.UploadHook {
    private static final long serialVersionUID = -2304521273582574603L;

    public boolean checkUpload(Collection<OsmPrimitive> add, Collection<OsmPrimitive> update, Collection<OsmPrimitive> delete) {
        Collection<Test> tests = OSMValidatorPlugin.getTests(false, true);
        if (tests.isEmpty()) {
            return true;
        }
        AgregatePrimitivesVisitor v = new AgregatePrimitivesVisitor();
        v.visit(add);
        Collection<OsmPrimitive> selection = v.visit(update);
        ArrayList<TestError> errors = new ArrayList<TestError>(30);
        for (Test test : tests) {
            if (!test.testBeforeUpload()) continue;
            test.setBeforeUpload(true);
            test.setPartialSelection(true);
            test.startTest();
            test.visit(selection);
            test.endTest();
            errors.addAll(test.getErrors());
        }
        tests = null;
        return this.displaErrorScreen(errors);
    }

    private boolean displaErrorScreen(List<TestError> errors) {
        if (errors == null || errors.isEmpty()) {
            return true;
        }
        JPanel p = new JPanel(new GridBagLayout());
        ErrorTreePanel errorPanel = new ErrorTreePanel(errors);
        errorPanel.expandAll();
        p.add((Component)new JScrollPane(errorPanel), GBC.eol());
        return JOptionPane.showConfirmDialog(Main.parent, p, I18n.tr((String)"Data with errors. Upload anyway?"), 0) == 0;
    }
}

