/*
 * Decompiled with CFR 0.152.
 */
package mappaint;

import java.awt.Color;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import mappaint.AreaElemStyle;
import mappaint.ElemStyle;
import mappaint.ElemStyles;
import mappaint.IconElemStyle;
import mappaint.LineElemStyle;
import mappaint.MapPaintPlugin;
import org.openstreetmap.josm.tools.ColorHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ElemStyleHandler
extends DefaultHandler {
    boolean inDoc = false;
    boolean inRule = false;
    boolean inCondition = false;
    boolean inElemStyle = false;
    boolean inLine = false;
    boolean inIcon = false;
    boolean inArea = false;
    boolean inScaleMax;
    boolean inScaleMin;
    ElemStyles styles = new ElemStyles();
    String curKey = null;
    String curValue = null;
    int curLineWidth = -1;
    int curLineRealWidth = 0;
    boolean curLineDashed = false;
    Color curLineColour = null;
    Color curAreaColour = null;
    ImageIcon curIcon = null;
    boolean curIconAnnotate = true;
    long curScaleMax = 1000000000L;
    long curScaleMin = 0L;

    public void setElemStyles(ElemStyles styles) {
        this.styles = styles;
    }

    public void startDocument() {
        this.inDoc = true;
    }

    public void endDocument() {
        this.inDoc = false;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        block24: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    if (!this.inDoc) break block24;
                                    if (!qName.equals("rule")) break block25;
                                    this.inRule = true;
                                    break block24;
                                }
                                if (!qName.equals("condition") || !this.inRule) break block26;
                                this.inCondition = true;
                                int count = 0;
                                while (count < atts.getLength()) {
                                    if (atts.getQName(count).equals("k")) {
                                        this.curKey = atts.getValue(count);
                                    } else if (atts.getQName(count).equals("v")) {
                                        this.curValue = atts.getValue(count);
                                    }
                                    ++count;
                                }
                                break block24;
                            }
                            if (!qName.equals("line")) break block27;
                            this.inLine = true;
                            int count = 0;
                            while (count < atts.getLength()) {
                                if (atts.getQName(count).equals("width")) {
                                    this.curLineWidth = Integer.parseInt(atts.getValue(count));
                                } else if (atts.getQName(count).equals("colour")) {
                                    this.curLineColour = ColorHelper.html2color((String)atts.getValue(count));
                                } else if (atts.getQName(count).equals("realwidth")) {
                                    this.curLineRealWidth = Integer.parseInt(atts.getValue(count));
                                } else if (atts.getQName(count).equals("dashed")) {
                                    this.curLineDashed = Boolean.parseBoolean(atts.getValue(count));
                                }
                                ++count;
                            }
                            break block24;
                        }
                        if (!qName.equals("scale_max")) break block28;
                        this.inScaleMax = true;
                        break block24;
                    }
                    if (!qName.equals("scale_min")) break block29;
                    this.inScaleMin = true;
                    break block24;
                }
                if (!qName.equals("icon")) break block30;
                this.inIcon = true;
                int count = 0;
                while (count < atts.getLength()) {
                    block23: {
                        if (atts.getQName(count).equals("src")) {
                            String imageFile = String.valueOf(MapPaintPlugin.getStyleDir()) + "icons/" + atts.getValue(count);
                            File f = new File(imageFile);
                            if (f.exists()) {
                                this.curIcon = new ImageIcon(imageFile);
                            } else {
                                try {
                                    URL path = this.getClass().getResource("/standard/icons/" + atts.getValue(count));
                                    if (path == null) {
                                        System.out.println("Mappaint: Icon " + atts.getValue(count) + " not found, using default icon");
                                        path = this.getClass().getResource("/standard/icons/misc/no_icon.png");
                                        this.curIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(path));
                                        break block23;
                                    }
                                    this.curIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(path));
                                }
                                catch (Exception e) {
                                    URL path = this.getClass().getResource("/standard/icons/amenity.png");
                                    this.curIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(path));
                                }
                            }
                        } else if (atts.getQName(count).equals("annotate")) {
                            this.curIconAnnotate = Boolean.parseBoolean(atts.getValue(count));
                        }
                    }
                    ++count;
                }
                break block24;
            }
            if (!qName.equals("area")) break block24;
            this.inArea = true;
            int count = 0;
            while (count < atts.getLength()) {
                if (atts.getQName(count).equals("colour")) {
                    this.curAreaColour = ColorHelper.html2color((String)atts.getValue(count));
                }
                ++count;
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inRule && qName.equals("rule")) {
            ElemStyle newStyle;
            this.inRule = false;
            if (this.curLineWidth != -1) {
                newStyle = new LineElemStyle(this.curLineWidth, this.curLineRealWidth, this.curLineColour, this.curLineDashed, this.curScaleMax, this.curScaleMin);
                this.styles.add(this.curKey, this.curValue, newStyle);
                this.curLineWidth = -1;
                this.curLineRealWidth = 0;
                this.curLineDashed = false;
                this.curLineColour = null;
            }
            if (this.curIcon != null) {
                newStyle = new IconElemStyle(this.curIcon, this.curIconAnnotate, this.curScaleMax, this.curScaleMin);
                this.styles.add(this.curKey, this.curValue, newStyle);
                this.curIcon = null;
                this.curIconAnnotate = true;
            }
            if (this.curAreaColour != null) {
                newStyle = new AreaElemStyle(this.curAreaColour, this.curScaleMax, this.curScaleMin);
                this.styles.add(this.curKey, this.curValue, newStyle);
                this.curAreaColour = null;
            }
            this.curScaleMax = 1000000000L;
            this.curScaleMin = 0L;
        } else if (this.inCondition && qName.equals("condition")) {
            this.inCondition = false;
        } else if (this.inLine && qName.equals("line")) {
            this.inLine = false;
        } else if (this.inIcon && qName.equals("icon")) {
            this.inIcon = false;
        } else if (this.inArea && qName.equals("area")) {
            this.inArea = false;
        } else if (qName.equals("scale_max")) {
            this.inScaleMax = false;
        } else if (qName.equals("scale_min")) {
            this.inScaleMin = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
        String content;
        if (this.inScaleMax) {
            content = new String(ch, start, length);
            this.curScaleMax = Long.parseLong(content);
        }
        if (this.inScaleMin) {
            content = new String(ch, start, length);
            this.curScaleMin = Long.parseLong(content);
        }
    }
}

