/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntaggedNode
extends Test {
    public static String[] allowedTags = new String[]{"created_by"};
    Set<Node> emptyNodes;

    public UntaggedNode() {
        super(I18n.tr((String)"Untagged nodes."), I18n.tr((String)"This test checks for untagged nodes that are not part of any way."));
    }

    @Override
    public void startTest() {
        this.emptyNodes = new HashSet<Node>(100);
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        if (this.partialSelection) {
            for (OsmPrimitive p : selection) {
                if (p.deleted || !(p instanceof Node)) continue;
                p.visit((Visitor)this);
            }
            for (Way w : Main.ds.ways) {
                this.visit(w);
            }
        } else {
            for (OsmPrimitive p : selection) {
                if (p.deleted) continue;
                p.visit((Visitor)this);
            }
        }
    }

    @Override
    public void visit(Node n) {
        int numTags = 0;
        Map tags = n.keys;
        if (tags != null) {
            numTags = tags.size();
            for (String tag : allowedTags) {
                if (!tags.containsKey(tag)) continue;
                --numTags;
            }
        }
        if (numTags == 0) {
            this.emptyNodes.add(n);
        }
    }

    @Override
    public void visit(Way w) {
        for (Node n : w.nodes) {
            this.emptyNodes.remove(n);
        }
    }

    @Override
    public void endTest() {
        for (Node node : this.emptyNodes) {
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Untagged and unconnected nodes"), (OsmPrimitive)node));
        }
        this.emptyNodes = null;
    }

    @Override
    public Command fixError(TestError testError) {
        return new DeleteCommand(testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof UntaggedNode;
    }
}

