/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

public class SimilarNamedWays
extends Test {
    Map<Point2D, List<Way>> cellWays;
    Bag<Way, Way> errorWays;

    public SimilarNamedWays() {
        super(I18n.tr((String)"Similar named ways."), I18n.tr((String)"This test checks for ways with similar names that may have been misspelled."));
    }

    public void startTest() {
        this.cellWays = new HashMap<Point2D, List<Way>>(1000);
        this.errorWays = new Bag();
    }

    public void endTest() {
        this.cellWays = null;
        this.errorWays = null;
    }

    public void visit(Way w) {
        if (w.deleted) {
            return;
        }
        String name = w.get("name");
        if (name == null || name.length() < 6) {
            return;
        }
        List<List<Way>> theCellWays = Util.getWaysInCell(w, this.cellWays);
        for (List<Way> ways : theCellWays) {
            for (Way w2 : ways) {
                int levenshteinDistance;
                String name2;
                if (this.errorWays.contains(w, w2) || this.errorWays.contains(w2, w) || (name2 = w2.get("name")) == null || name2.length() < 6 || 0 >= (levenshteinDistance = this.getLevenshteinDistance(name, name2)) || levenshteinDistance > 2) continue;
                ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
                primitives.add((OsmPrimitive)w);
                primitives.add((OsmPrimitive)w2);
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Similar named ways"), primitives));
                this.errorWays.add(w, w2);
            }
            ways.add(w);
        }
    }

    public int getLevenshteinDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = SimilarNamedWays.Minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int Minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }
}

