/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MultipleNameVisitor
extends NameVisitor {
    String multipleClassname;
    int size;

    public void visit(Collection<? extends OsmPrimitive> data) {
        this.size = data.size();
        this.multipleClassname = null;
        for (OsmPrimitive osmPrimitive : data) {
            osmPrimitive.visit((Visitor)this);
            if (this.multipleClassname == null) {
                this.multipleClassname = this.className;
                continue;
            }
            if (this.multipleClassname.equals(this.className)) continue;
            this.multipleClassname = "object";
        }
    }

    public JLabel toLabel() {
        if (this.size == 1) {
            return super.toLabel();
        }
        return new JLabel(this.size + " " + I18n.trn((String)this.multipleClassname, (String)(this.multipleClassname + "s"), (long)this.size), ImageProvider.get((String)"data", (String)this.multipleClassname), 0);
    }

    public String getText() {
        if (this.size == 1) {
            return this.name;
        }
        return this.size + " " + I18n.trn((String)this.multipleClassname, (String)(this.multipleClassname + "s"), (long)this.size);
    }

    public Icon getIcon() {
        if (this.size == 1) {
            return this.icon;
        }
        return ImageProvider.get((String)"data", (String)this.multipleClassname);
    }
}

