/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    Map<Point2D, List<Way>> _cellWays;
    Bag<Way, Way> _errorWays;

    public Coastlines() {
        super(I18n.tr((String)"Coastlines."), I18n.tr((String)"This test checks that coastlines are correct."));
    }

    @Override
    public void startTest() {
        this._cellWays = new HashMap<Point2D, List<Way>>(1000);
        this._errorWays = new Bag();
    }

    @Override
    public void endTest() {
        this._cellWays = null;
        this._errorWays = null;
    }

    @Override
    public void visit(Way w) {
        if (w.deleted) {
            return;
        }
        String natural = w.get("natural");
        if (natural == null || !natural.equals("coastline")) {
            return;
        }
        List<List<Way>> cellWays = Util.getWaysInCell(w, this._cellWays);
        for (List<Way> ways : cellWays) {
            for (Way w2 : ways) {
                String natural2;
                if (this._errorWays.contains(w, w2) || this._errorWays.contains(w2, w) || (natural2 = w.get("natural")) == null || !natural2.equals("coastline") || !((Node)w.nodes.get(0)).equals(w2.nodes.get(0)) && !((Node)w.nodes.get(w.nodes.size() - 1)).equals(w2.nodes.get(w2.nodes.size() - 1))) continue;
                ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
                primitives.add((OsmPrimitive)w);
                primitives.add((OsmPrimitive)w2);
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Unordered coastline"), primitives));
                this._errorWays.add(w, w2);
            }
            ways.add(w);
        }
    }
}

