/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.Constants;
import com.yourkit.util.Asserts;
import com.yourkit.util.Strings;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public final class Agent {
    public static final long CAPABILITY_ATTACHED_AGENT = 1024L;
    public static final long CAPABILITY_CAN_RECORD_J2EE = 4096L;
    public static final long CAPABILITY_EXCEPTION_EVENTS_NOT_AVAILABLE = 16384L;
    private static final boolean USE_PARENTHESES = Constants.OS_WINDOWS;
    public static final String[] SNAPSHOT_NAME_MACROS = new String[]{"<date>", "<datetime>"};
    public static final String DEFAULT_SNAPSHOT_NAME_PATTERN = "<sessionname>-<date>";

    private static String getDateForSnapshotFileName() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(new Date());
    }

    private static String getDateTimeForSnapshotFileName() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm", Locale.US).format(new Date());
    }

    private static String expandSnapshotNameMacros(String nameWithMacros, String sessionName) {
        Asserts.notNull(sessionName);
        String name = nameWithMacros;
        name = Strings.replace(name, "<sessionname>", Agent.sessionNameToFileNamePart(sessionName));
        name = Strings.replace(name, "<date>", Agent.getDateForSnapshotFileName());
        name = Strings.replace(name, "<datetime>", Agent.getDateTimeForSnapshotFileName());
        return name;
    }

    private static String getFileName(String fileNamePrefix, int index, String fileExtension) {
        if (index == 0) {
            return fileNamePrefix + fileExtension;
        }
        if (USE_PARENTHESES) {
            return fileNamePrefix + "(" + index + ")" + fileExtension;
        }
        return fileNamePrefix + "-" + index + fileExtension;
    }

    public static File suggestSnapshotFile(File directory, String sessionName, String optionalFileName, String fileExtension) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Asserts.notNull(optionalFileName);
        Asserts.notNull(fileExtension);
        String fileNameExpanded = Agent.expandSnapshotNameMacros(optionalFileName.isEmpty() ? DEFAULT_SNAPSHOT_NAME_PATTERN : optionalFileName, sessionName);
        File[] files = directory.listFiles();
        if (files == null) {
            int index = 0;
            while (true) {
                File result;
                if (!(result = new File(directory, Agent.getFileName(fileNameExpanded, index, fileExtension))).exists()) {
                    return result;
                }
                ++index;
            }
        }
        int maxFound = -1;
        String start = USE_PARENTHESES ? fileNameExpanded + "(" : fileNameExpanded + "-";
        String end = USE_PARENTHESES ? ")" + fileExtension : fileExtension;
        String nameWithoutNumber = Agent.getFileName(fileNameExpanded, 0, fileExtension);
        for (File file : files) {
            String name = file.getName();
            if (name.equals(nameWithoutNumber)) {
                maxFound = Math.max(maxFound, 0);
                continue;
            }
            if (!name.startsWith(start) || !name.endsWith(end)) continue;
            String numberStr = name.substring(start.length(), name.length() - end.length());
            try {
                int value = Integer.parseInt(numberStr);
                maxFound = Math.max(value, maxFound);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return new File(directory, Agent.getFileName(fileNameExpanded, maxFound + 1, fileExtension));
    }

    private static String sessionNameToFileNamePart(String sessionName) {
        StringBuilder result = new StringBuilder(sessionName.length());
        for (int i = 0; i < sessionName.length(); ++i) {
            char ch = sessionName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '.') {
                result.append(ch);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    public static byte[][] getBytecode(Class[] classes) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (Class aClass : classes) {
            Agent.addBytecode(result, new Class[]{aClass});
            result.add(null);
        }
        return (byte[][])result.toArray((T[])new byte[result.size()][]);
    }

    private static void addBytecode(ArrayList<byte[]> result, Class[] classes) {
        for (Class aClass : classes) {
            result.add(Agent.getClassBytes(aClass));
            Agent.addBytecode(result, aClass.getDeclaredClasses());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getClassBytes(Class aClass) {
        ByteArray byteArray = new ByteArray(1024);
        try {
            InputStream stream = aClass.getResourceAsStream("/" + aClass.getName().replace('.', '/') + ".class");
            try {
                int ch;
                while ((ch = stream.read()) != -1) {
                    byteArray.add((byte)ch);
                }
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return byteArray.getBytes();
    }

    private static final class ByteArray {
        private byte[] myBytes;
        private int mySize;

        public ByteArray(int initialCapacity) {
            this.myBytes = new byte[initialCapacity];
        }

        public void add(byte aByte) {
            if (this.mySize == this.myBytes.length) {
                int newCapacity = this.myBytes.length * 2;
                byte[] newBytes = new byte[newCapacity];
                System.arraycopy(this.myBytes, 0, newBytes, 0, this.mySize);
                this.myBytes = newBytes;
            }
            this.myBytes[this.mySize++] = aByte;
        }

        public byte[] getBytes() {
            byte[] result = new byte[this.mySize];
            System.arraycopy(this.myBytes, 0, result, 0, this.mySize);
            return result;
        }
    }
}

