/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.util.Asserts;
import java.util.HashMap;
import java.util.Set;

public final class ProbesConfiguration {
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    private final HashMap<String, Integer> myProbeClasses2State;

    public ProbesConfiguration() {
        this.myProbeClasses2State = new HashMap();
    }

    public ProbesConfiguration(ProbesConfiguration second) {
        this.myProbeClasses2State = new HashMap<String, Integer>(second.myProbeClasses2State);
    }

    public String[] getProbeClasses() {
        Set<String> probeClasses = this.myProbeClasses2State.keySet();
        return probeClasses.toArray(new String[probeClasses.size()]);
    }

    public boolean isEmpty() {
        return this.myProbeClasses2State.isEmpty();
    }

    public int getState(String probeClass) {
        Integer state = this.myProbeClasses2State.get(probeClass);
        return state != null ? state : 0;
    }

    public boolean isRegistered(String probeClass) {
        return this.getState(probeClass) != 0;
    }

    public void clear() {
        this.myProbeClasses2State.clear();
    }

    public void set(String probeClass, int state) {
        Asserts.notNull(probeClass);
        this.myProbeClasses2State.put(probeClass, state);
    }

    public static ProbesConfiguration getDifference(ProbesConfiguration oldConfiguration, ProbesConfiguration newConfiguration) {
        Asserts.notNull(oldConfiguration);
        Asserts.notNull(newConfiguration);
        ProbesConfiguration result = new ProbesConfiguration();
        for (String probeClass : newConfiguration.getProbeClasses()) {
            int newState;
            int oldState = oldConfiguration.getState(probeClass);
            if (oldState == (newState = newConfiguration.getState(probeClass))) continue;
            result.set(probeClass, newState);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProbesConfiguration)) {
            return false;
        }
        ProbesConfiguration probesConfiguration = (ProbesConfiguration)o;
        return this.myProbeClasses2State.equals(probesConfiguration.myProbeClasses2State);
    }

    public int hashCode() {
        return this.myProbeClasses2State.hashCode();
    }
}

