/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.CommandLineUiCallback;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.cloud.BugCollectionStorageCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.launchGUI.LaunchGUI;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSummarizeAndView {
    SortedBugCollection results;
    SortedBugCollection scaryBugs;
    int numLowConfidence = 0;
    int tooOld = 0;
    int harmless = 0;
    boolean isConnectedToCloud;
    Cloud cloud;
    Cloud.Mode originalMode;
    final MSVOptions options;
    static final long NOW;

    public static SortedBugCollection union(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        SortedBugCollection result = origCollection.duplicate();
        for (BugInstance bugInstance : newCollection) {
            result.add(bugInstance);
        }
        ProjectStats stats = result.getProjectStats();
        ProjectStats stats2 = newCollection.getProjectStats();
        stats.addStats(stats2);
        Project project = result.getProject();
        project.add(newCollection.getProject());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int argCount;
        FindBugs.setNoAnalysis();
        MSVOptions options = new MSVOptions();
        MSVCommandLine commandLine = new MSVCommandLine(options);
        for (int i = argCount = commandLine.parse(argv, 1, Integer.MAX_VALUE, new StringBuilder().append("Usage: ").append(MergeSummarizeAndView.class.getName()).append(" [options] [<results1> <results2> ... <resultsn>] ").toString()); i < argv.length; ++i) {
            options.analysisFiles.add(argv[i]);
        }
        MergeSummarizeAndView msv = new MergeSummarizeAndView(options);
        boolean isCloudManagedByGui = false;
        try {
            msv.load();
            isCloudManagedByGui = msv.report();
            Object var7_7 = null;
            if (!isCloudManagedByGui) {
                msv.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!isCloudManagedByGui) {
                msv.shutdown();
            }
            throw throwable;
        }
    }

    public MergeSummarizeAndView(MSVOptions options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.load();
            Object var2_1 = null;
            this.shutdown();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.shutdown();
            throw throwable;
        }
    }

    public boolean isConnectedToCloud() {
        return this.isConnectedToCloud;
    }

    public int numScaryBugs() {
        return this.scaryBugs.getCollection().size();
    }

    public BugCollection getScaryBugs() {
        return this.scaryBugs;
    }

    public BugCollection getAllBugs() {
        return this.scaryBugs;
    }

    public int getHarmless() {
        return this.harmless;
    }

    public int getLowConfidence() {
        return this.numLowConfidence;
    }

    public int getTooOld() {
        return this.tooOld;
    }

    private void shutdown() {
        if (this.cloud != null) {
            this.cloud.shutdown();
            this.cloud = null;
        }
    }

    private void load() {
        long old2;
        String userDir;
        if (this.options.workingDirList.isEmpty() && null != (userDir = System.getProperty("user.dir")) && !"".equals(userDir)) {
            this.options.workingDirList.add(userDir);
        }
        CommandLineUiCallback cliUiCallback = new CommandLineUiCallback();
        for (String analysisFile : this.options.analysisFiles) {
            try {
                SortedBugCollection more = MergeSummarizeAndView.createPreconfiguredBugCollection(this.options.workingDirList, this.options.srcDirList, cliUiCallback);
                more.readXML(analysisFile);
                BugRanker.trimToMaxRank(more, this.options.maxConsideredRank);
                if (this.results != null) {
                    this.results = MergeSummarizeAndView.union(this.results, more);
                    continue;
                }
                this.results = more;
            }
            catch (IOException e) {
                System.err.println("Trouble reading " + analysisFile);
            }
            catch (DocumentException e) {
                System.err.println("Trouble parsing " + analysisFile);
            }
        }
        if (this.results == null) {
            throw new RuntimeException("No files successfully read");
        }
        if (this.options.cloudId != null) {
            this.results.getProject().setCloudId(this.options.cloudId);
            this.results.reinitializeCloud();
        }
        this.cloud = this.results.getCloud();
        this.cloud.waitUntilIssueDataDownloaded();
        this.isConnectedToCloud = !(this.cloud instanceof BugCollectionStorageCloud);
        Project project = this.results.getProject();
        this.originalMode = this.cloud.getMode();
        this.cloud.setMode(Cloud.Mode.COMMUNAL);
        long old = System.currentTimeMillis() - (long)this.options.maxAge * 86400000L;
        if (this.options.baselineDate != null && (old2 = this.options.baselineDate.getTime()) > old) {
            old = old2;
        }
        this.scaryBugs = this.results.createEmptyCollectionWithMetadata();
        for (BugInstance warning : this.results.getCollection()) {
            boolean highRank;
            int rank;
            if (project.getSuppressionFilter().match(warning) || (rank = BugRanker.findRank(warning)) > 20) continue;
            if (this.cloud.getConsensusDesignation(warning).score() < 0) {
                ++this.harmless;
                continue;
            }
            long firstSeen = this.cloud.getFirstSeen(warning);
            boolean isOld = FindBugs.validTimestamp(firstSeen) && firstSeen < old;
            boolean bl = highRank = rank > this.options.maxRank;
            if (highRank) {
                ++this.numLowConfidence;
                continue;
            }
            if (isOld) {
                ++this.tooOld;
                continue;
            }
            this.scaryBugs.add(warning);
        }
    }

    private boolean report() {
        boolean hasScaryBugs;
        assert (this.cloud == this.results.getCloud());
        boolean bl = hasScaryBugs = !this.scaryBugs.getCollection().isEmpty();
        if (hasScaryBugs) {
            System.out.printf("%4s%n", "days");
            System.out.printf("%4s %4s %s%n", "old", "rank", "issue");
            for (BugInstance warning : this.scaryBugs) {
                int rank = BugRanker.findRank(warning);
                long firstSeen = this.cloud.getFirstSeen(warning);
                System.out.printf("%4d %4d %s%n", MergeSummarizeAndView.ageInDays(firstSeen), rank, warning.getMessageWithoutPrefix());
            }
        }
        if ((this.numLowConfidence > 0 || this.tooOld > 0) && hasScaryBugs) {
            System.out.println();
            System.out.print("plus ");
            if (this.numLowConfidence > 0) {
                System.out.printf("%d less scary recent issues", this.numLowConfidence);
            }
            if (this.numLowConfidence > 0 && this.tooOld > 0) {
                System.out.printf(" and ", new Object[0]);
            }
            if (this.tooOld > 0) {
                System.out.printf("%d older issues", this.tooOld);
            }
            System.out.println();
        }
        if (hasScaryBugs || this.options.alwaysShowGui && this.results.getCollection().size() > 0) {
            if (GraphicsEnvironment.isHeadless()) {
                System.out.println("Running in GUI headless mode, can't open GUI");
                return false;
            }
            this.cloud.setMode(this.originalMode);
            LaunchGUI.launchGUI(this.results);
            return true;
        }
        return false;
    }

    static SortedBugCollection createPreconfiguredBugCollection(List<String> workingDirList, List<String> srcDirList, IGuiCallback guiCallback) {
        Project project = new Project();
        for (String cwd : workingDirList) {
            project.addWorkingDir(cwd);
        }
        for (String srcDir : srcDirList) {
            project.addSourceDir(srcDir);
        }
        project.setGuiCallback(guiCallback);
        return new SortedBugCollection(project);
    }

    static int ageInDays(long firstSeen) {
        return (int)(NOW - firstSeen) / 24 / 3600 / 1000;
    }

    static {
        DetectorFactoryCollection.instance();
        NOW = System.currentTimeMillis();
    }

    static class MSVCommandLine
    extends CommandLine {
        final MSVOptions options;

        public MSVCommandLine(MSVOptions options) {
            this.options = options;
            this.addOption("-workingDir", "filename", "Comma separated list of current working directory paths, used to resolve relative paths (Jar, AuxClasspathEntry, SrcDir)");
            this.addOption("-cloud", "id", "id of the cloud to use");
            this.addOption("-srcDir", "filename", "Comma separated list of directory paths, used to resolve relative SourceFile paths");
            this.addOption("-maxRank", "rank", "maximum rank of issues to show in summary (default 12)");
            this.addOption("-maxConsideredRank", "rank", "maximum rank of issues to consider (default 14)");
            this.addOption("-maxAge", "days", "maximum age of issues to show in summary");
            this.addOption("-baseline", "date", "issues before this date are considered old (date format is MM/dd/yyyy)");
            this.addSwitch("-gui", "display GUI for any warnings. Default: Displays GUI for warnings meeting filtering criteria");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (!option.equals("-gui")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.options.alwaysShowGui = true;
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-workingDir")) {
                this.options.workingDirList = Arrays.asList(argument.split(","));
            } else if (option.equals("-srcDir")) {
                this.options.srcDirList = Arrays.asList(argument.split(","));
            } else if (option.equals("-maxRank")) {
                this.options.maxRank = Integer.parseInt(argument);
            } else if (option.equals("-maxAge")) {
                this.options.maxAge = Integer.parseInt(argument);
            } else if (option.equals("-cloud")) {
                this.options.cloudId = argument;
            } else if (option.equals("-baseline")) {
                try {
                    this.options.baselineDate = new SimpleDateFormat("MM/dd/yyyy").parse(argument);
                }
                catch (ParseException e) {
                    System.err.println("Date " + argument + " not in MM/dd/yyyy format (e.g., 05/13/2009)");
                }
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }
    }

    public static class MSVOptions {
        public List<String> workingDirList = new ArrayList<String>();
        public List<String> analysisFiles = new ArrayList<String>();
        public List<String> srcDirList = new ArrayList<String>();
        public int maxRank = 12;
        public int maxConsideredRank = 14;
        public int maxAge = 10000;
        public boolean alwaysShowGui = false;
        @CheckForNull
        public Date baselineDate;
        public String cloudId;
    }
}

