/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import edu.umd.cs.findbugs.classfile.impl.SingleFileCodeBaseEntry;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;

public class SingleFileCodeBase
implements IScannableCodeBase {
    private ICodeBaseLocator codeBaseLocator;
    private String fileName;
    private boolean isAppCodeBase;
    private int howDiscovered;
    private long lastModifiedTime;
    private boolean resourceNameKnown;
    private String resourceName;

    public SingleFileCodeBase(ICodeBaseLocator codeBaseLocator, String fileName) {
        this.codeBaseLocator = codeBaseLocator;
        this.fileName = fileName;
        this.lastModifiedTime = new File(fileName).lastModified();
    }

    public String toString() {
        return this.fileName;
    }

    public ICodeBaseLocator getCodeBaseLocator() {
        return this.codeBaseLocator;
    }

    public boolean containsSourceFiles() throws InterruptedException {
        return false;
    }

    public ICodeBaseIterator iterator() throws InterruptedException {
        return new ICodeBaseIterator(){
            boolean done = false;

            public boolean hasNext() throws InterruptedException {
                return !this.done;
            }

            public ICodeBaseEntry next() throws InterruptedException {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return new SingleFileCodeBaseEntry(SingleFileCodeBase.this);
            }
        };
    }

    public ICodeBaseEntry lookupResource(String resourceName) {
        if (!resourceName.equals(this.getResourceName())) {
            return null;
        }
        return new SingleFileCodeBaseEntry(this);
    }

    public void setApplicationCodeBase(boolean isAppCodeBase) {
        this.isAppCodeBase = isAppCodeBase;
    }

    public boolean isApplicationCodeBase() {
        return this.isAppCodeBase;
    }

    public void setHowDiscovered(int howDiscovered) {
        this.howDiscovered = howDiscovered;
    }

    public int getHowDiscovered() {
        return this.howDiscovered;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        if (lastModifiedTime > 0L && FindBugs.validTimestamp(lastModifiedTime)) {
            this.lastModifiedTime = lastModifiedTime;
        }
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getPathName() {
        return this.fileName;
    }

    InputStream openFile() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.fileName));
    }

    public void close() {
    }

    String getResourceName() {
        if (!this.resourceNameKnown) {
            try {
                this.resourceName = this.getClassDescriptor().toResourceName();
            }
            catch (Exception e) {
                this.resourceName = this.fileName;
            }
            this.resourceNameKnown = true;
        }
        return this.resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ClassDescriptor getClassDescriptor() throws ResourceNotFoundException, InvalidClassFileFormatException {
        DataInputStream in = null;
        try {
            ClassDescriptor classDescriptor;
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
                ClassParser classParser = new ClassParser(in, null, new SingleFileCodeBaseEntry(this));
                ClassNameAndSuperclassInfo.Builder builder = new ClassNameAndSuperclassInfo.Builder();
                classParser.parse(builder);
                classDescriptor = builder.build().getClassDescriptor();
                Object var6_6 = null;
                if (in == null) return classDescriptor;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (in != null) {
                    IO.close(in);
                }
                throw throwable;
            }
            IO.close(in);
            return classDescriptor;
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(this.fileName);
        }
    }

    int getNumBytes() {
        File file = new File(this.fileName);
        return (int)file.length();
    }
}

