/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.heap;

import edu.umd.cs.findbugs.ba.XField;
import java.util.HashSet;
import java.util.Set;

public class FieldSet {
    private boolean isTop;
    private boolean isBottom;
    private Set<XField> fieldSet = new HashSet<XField>();

    public void setTop() {
        this.clear();
        this.isTop = true;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setBottom() {
        this.clear();
        this.isBottom = true;
    }

    public boolean isBottom() {
        return this.isBottom;
    }

    public boolean isValid() {
        return !this.isTop && !this.isBottom;
    }

    public boolean isEmpty() {
        return !this.isTop && !this.isBottom && this.fieldSet.isEmpty();
    }

    public void clear() {
        this.isBottom = false;
        this.isTop = false;
        this.fieldSet.clear();
    }

    public void addField(XField field) {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        this.fieldSet.add(field);
    }

    public boolean contains(XField field) {
        return this.fieldSet.contains(field);
    }

    public void mergeWith(FieldSet other) {
        if (other.isTop() || this.isBottom()) {
            return;
        }
        if (other.isBottom() || this.isTop()) {
            this.copyFrom(other);
            return;
        }
        this.fieldSet.addAll(other.fieldSet);
    }

    public boolean sameAs(FieldSet other) {
        return this.isTop == other.isTop && this.isBottom == other.isBottom && ((Object)this.fieldSet).equals(other.fieldSet);
    }

    public void copyFrom(FieldSet other) {
        this.isTop = other.isTop;
        this.isBottom = other.isBottom;
        this.fieldSet.clear();
        this.fieldSet.addAll(other.fieldSet);
    }

    public boolean isIntersectionNonEmpty(FieldSet other) {
        for (XField field : this.fieldSet) {
            if (!other.fieldSet.contains(field)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isTop) {
            return "TOP";
        }
        if (this.isBottom) {
            return "BOTTOM";
        }
        return this.fieldSet.toString();
    }
}

