/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Iterator;

public class Obfuscate {
    static final String HASH_SEED = SystemProperties.getProperty("hashSeed", "");

    public static String hashData(String in) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest((HASH_SEED + in).getBytes("UTF-8"));
            return String.format("%040x", new BigInteger(1, hash));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String hashFilename(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            String suffix = fileName.substring(lastDot);
            return Obfuscate.hashData(fileName.substring(0, lastDot)) + suffix;
        }
        return Obfuscate.hashData(fileName);
    }

    public static String hashClass(@DottedClassName String className) {
        if (className.startsWith("java")) {
            return className;
        }
        return "obfuscated.H" + Obfuscate.hashData(className);
    }

    public static String hashSignature(String signature) {
        char firstChar = signature.charAt(0);
        switch (firstChar) {
            case '[': {
                return '[' + Obfuscate.hashSignature(signature.substring(1));
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                if (signature.length() == 1) {
                    return signature;
                }
                throw new IllegalArgumentException("bad signature: " + signature);
            }
            case 'L': {
                if (!signature.endsWith(";")) {
                    throw new IllegalArgumentException("bad signature: " + signature);
                }
                return Obfuscate.hashFieldSignature(signature);
            }
        }
        throw new IllegalArgumentException("bad signature: " + signature);
    }

    public static String hashFieldSignature(String signature) {
        if (!(signature = signature.substring(1, signature.length() - 1)).startsWith("java")) {
            signature = "obfuscated/H" + Obfuscate.hashData(signature);
        }
        return "L" + signature + ";";
    }

    public static String hashMethodSignature(String signature) {
        SignatureParser parser = new SignatureParser(signature);
        StringBuilder buf = new StringBuilder("(");
        Iterator<String> i = parser.parameterSignatureIterator();
        while (i.hasNext()) {
            String param = i.next();
            buf.append(Obfuscate.hashSignature(param));
        }
        buf.append(")");
        buf.append(Obfuscate.hashSignature(parser.getReturnTypeSignature()));
        return buf.toString();
    }

    static MethodAnnotation obfuscate(MethodAnnotation m) {
        String className = m.getClassName();
        if (className.startsWith("java")) {
            return m;
        }
        String methodName = m.getMethodName();
        String methodSignature = m.getMethodSignature();
        if (!(methodName.equals("hashCode") && methodSignature.equals("()I") || methodName.equals("equals") && methodSignature.equals("(Ljava/lang/Object;)Z") || methodName.equals("compareTo") && methodSignature.equals("(Ljava/lang/Object;)I") || methodName.equals("<init>") || methodName.equals("<clinit>"))) {
            methodName = Obfuscate.hashData(methodName);
        }
        MethodAnnotation result = new MethodAnnotation(Obfuscate.hashClass(className), methodName, Obfuscate.hashMethodSignature(methodSignature), m.isStatic());
        result.setDescription(m.getDescription());
        return result;
    }

    static FieldAnnotation obfuscate(FieldAnnotation m) {
        FieldAnnotation result = new FieldAnnotation(Obfuscate.hashClass(m.getClassName()), Obfuscate.hashData(m.getFieldName()), Obfuscate.hashSignature(m.getFieldSignature()), m.isStatic());
        result.setDescription(m.getDescription());
        return result;
    }

    static ClassAnnotation obfuscate(ClassAnnotation m) {
        ClassAnnotation result = new ClassAnnotation(Obfuscate.hashClass(m.getClassName()));
        result.setDescription(m.getDescription());
        return result;
    }

    static TypeAnnotation obfuscate(TypeAnnotation m) {
        TypeAnnotation result = new TypeAnnotation(Obfuscate.hashSignature(m.getTypeDescriptor()));
        result.setDescription(m.getDescription());
        return result;
    }

    static IntAnnotation obfuscate(IntAnnotation m) {
        IntAnnotation result = new IntAnnotation(m.getValue());
        result.setDescription(m.getDescription());
        return result;
    }

    static StringAnnotation obfuscate(StringAnnotation m) {
        StringAnnotation result = new StringAnnotation("obfuscated: " + Obfuscate.hashData(m.getValue()));
        result.setDescription(m.getDescription());
        return result;
    }

    static SourceLineAnnotation obfuscate(SourceLineAnnotation m) {
        SourceLineAnnotation result = new SourceLineAnnotation(Obfuscate.hashClass(m.getClassName()), Obfuscate.hashFilename(m.getSourceFile()), m.getStartLine(), m.getEndLine(), m.getStartBytecode(), m.getEndBytecode());
        result.setDescription(m.getDescription());
        return result;
    }

    static LocalVariableAnnotation obfuscate(LocalVariableAnnotation m) {
        LocalVariableAnnotation result = new LocalVariableAnnotation(Obfuscate.hashData(m.getName()), m.getRegister(), m.getPC());
        result.setDescription(m.getDescription());
        return result;
    }

    public static BugInstance obfuscate(BugInstance b) {
        final BugInstance result = new BugInstance(b.getType(), b.getPriority());
        BugAnnotationVisitor visitor = new BugAnnotationVisitor(){

            public void visitTypeAnnotation(TypeAnnotation typeAnnotation) {
                result.add(Obfuscate.obfuscate(typeAnnotation));
            }

            public void visitStringAnnotation(StringAnnotation stringAnnotation) {
                result.add(Obfuscate.obfuscate(stringAnnotation));
            }

            public void visitSourceLineAnnotation(SourceLineAnnotation sourceLineAnnotation) {
                result.add(Obfuscate.obfuscate(sourceLineAnnotation));
            }

            public void visitMethodAnnotation(MethodAnnotation methodAnnotation) {
                result.add(Obfuscate.obfuscate(methodAnnotation));
            }

            public void visitLocalVariableAnnotation(LocalVariableAnnotation fieldAnnotation) {
                result.add(Obfuscate.obfuscate(fieldAnnotation));
            }

            public void visitIntAnnotation(IntAnnotation fieldAnnotation) {
                result.add(Obfuscate.obfuscate(fieldAnnotation));
            }

            public void visitFieldAnnotation(FieldAnnotation fieldAnnotation) {
                result.add(Obfuscate.obfuscate(fieldAnnotation));
            }

            public void visitClassAnnotation(ClassAnnotation classAnnotation) {
                result.add(Obfuscate.obfuscate(classAnnotation));
            }
        };
        for (BugAnnotation bugAnnotation : b.getAnnotations()) {
            bugAnnotation.accept(visitor);
        }
        result.setOldInstanceHash(Obfuscate.hashData(b.getInstanceHash()));
        result.setHistory(b);
        return result;
    }
}

