/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.Constants;
import com.yourkit.api.ControllerImpl;
import java.lang.reflect.Field;

public final class Controller {
    private final ControllerImpl myImpl;
    public static final String DEFAULT_FILTERS = "$Dispatch*\n$Http*\n$Markup*\n$Page*\n$Property*\n$Proxy*\n$Request*\n+*TapestryFilter*\n+com.ibm.websphere.samples.*\n+org.apache.jsp.*\n+org.apache.maven.*\n+org.codehaus.groovy.runtime.DefaultGroovyMethods\n+org.codehaus.groovy.runtime.DefaultGroovyStaticMethods\nallaire.jrun*\nantlr.*\napple.*\natg.*\nbsh.*\nc8*\ncom.acumenat.*\ncom.adventnet.*\ncom.apple.*\ncom.asn1c.*\ncom.bea.*\ncom.beasys.*\ncom.borland.*\ncom.caucho.*\ncom.certicom.*\nCOM.cloudscape.*\ncom.evermind.*\ncom.ibm.*\ncom.inprise.*\ncom.intellij.rt.execution.*\ncom.iplanet.*\ncom.livesoftware*\ncom.netscape.server.http.*\nCOM.objectspace.*\ncom.octetstring.*\ncom.orionserver.*\ncom.phaos.*\ncom.pointbase.*\nCOM.rsa.*\ncom.rsa.*\ncom.sssw.*\ncom.sun.*\ncom.sybase.*\ncom.unify.*\ncom.visigenic.*\ncom.yourkit.probes.*\ncom.yourkit.runtime.*\ncompressionFilters.*\nfilters.*\ngnu.*\ngroovy.lang.*\ngroovyjarjarasm.*\njava.*\njavax.*\njrockit.*\njrun.*\njrunx.*\njunit.*\nlisteners.*\nnetscape.*\nnewatlanta.servletexec.*\norg.apache.*\norg.codehaus.groovy.*\norg.eclipse.*\norg.enhydra.*\norg.hsql.*\norg.jboss.*\norg.jbossmq.*\norg.mozilla.*\norg.omg.CORBA.*\norg.omg.CosNaming.*\norg.w3c.*\norg.xml.*\nsolid.*\nssa.*\nsun.*\nsunw.*\nweblogic.*";
    public static final String DEFAULT_WALLTIME_SPEC = "java.io.RandomAccessFile : readBytes(byte[], int, int)\njava.io.RandomAccessFile : read()\njava.io.RandomAccessFile : write(int)\njava.io.RandomAccessFile : writeBytes(byte[], int, int)\njava.net.SocketInputStream : socketRead0(java.io.FileDescriptor, byte[], int, int, int)\njava.net.SocketOutputStream : socketWrite0(java.io.FileDescriptor, byte[], int, int)\n";
    private static final String CMD_PRINT_STATUS = "print-current-status";
    private static final String CMD_CAPTURE_PERFORMANCE_SNAPSHOT = "capture-performance-snapshot";
    private static final String CMD_CAPTURE_MEMORY_SNAPSHOT = "capture-memory-snapshot";
    private static final String CMD_START_CPU_SAMPLING = "start-cpu-sampling";
    private static final String CMD_START_CPU_TRACING = "start-cpu-tracing";
    private static final String CMD_NOJ2EE = "noj2ee";
    private static final String CMD_NOPERCLASSGC = "no-per-class-gc";
    private static final String CMD_STOP_CPU_PROFILING = "stop-cpu-profiling";
    private static final String CMD_CLEAR_CPU_DATA = "clear-cpu-data";
    private static final String CMD_START_ALLOC_ALL = "start-alloc-recording-all";
    private static final String CMD_START_ALLOC_ADAPTIVE = "start-alloc-recording-adaptive";
    private static final String CMD_STOP_ALLOC = "stop-alloc-recording";
    private static final String CMD_CLEAR_ALLOC_DATA = "clear-alloc-data";
    private static final String CMD_START_MONITOR_PROFILING = "start-monitor-profiling";
    private static final String CMD_STOP_MONITOR_PROFILING = "stop-monitor-profiling";
    private static final String CMD_CLEAR_MONITOR_DATA = "clear-monitor-data";

    public Controller() throws Exception {
        this("localhost", Controller.getUsedPort());
    }

    public Controller(String host, int port) throws Exception {
        this.myImpl = new ControllerImpl(host, port);
    }

    public String getHost() {
        return this.myImpl.getHost();
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            port = (Integer)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    public String captureSnapshot(long snapshotFlags) throws Exception {
        if (snapshotFlags != 0L && snapshotFlags != 1L && snapshotFlags != 17L) {
            throw new IllegalArgumentException("illegal snapshotFlags value " + snapshotFlags + "; should be one of ProfilingModes.SNAPSHOT_xxx");
        }
        return this.myImpl.captureSnapshot(snapshotFlags, null, null, null);
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public void startAllocationRecording(boolean recordEachEnabled, int recordEach, boolean sizeLimitEnabled, int sizeLimit, boolean perClassGarbageStatistics) throws Exception {
        this.myImpl.startAllocationRecording(recordEachEnabled, recordEach, sizeLimitEnabled, sizeLimit, perClassGarbageStatistics);
    }

    public void startAllocationRecording(boolean recordEachEnabled, int recordEach, boolean sizeLimitEnabled, int sizeLimit) throws Exception {
        this.startAllocationRecording(recordEachEnabled, recordEach, sizeLimitEnabled, sizeLimit, true);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void clearAllocationData() throws Exception {
        this.myImpl.clearAllocationData();
    }

    public void startCPUProfiling(long mode, String filters) throws Exception {
        this.startCPUProfiling(mode, filters, DEFAULT_WALLTIME_SPEC);
    }

    public void startCPUProfiling(long mode, String filters, String wallTimeSpec) throws Exception {
        this.myImpl.startCPUProfiling(mode, filters, wallTimeSpec);
    }

    public void stopCPUProfiling() throws Exception {
        this.myImpl.stopCPUProfiling();
    }

    public void clearCPUData() throws Exception {
        this.myImpl.clearCPUData();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void clearMonitorData() throws Exception {
        this.myImpl.clearMonitorData();
    }

    public void enableStackTelemetry() throws Exception {
        this.myImpl.enableStackTelemetry();
    }

    public void disableStackTelemetry() throws Exception {
        this.myImpl.disableStackTelemetry();
    }

    public void enableExceptionTelemetry() throws Exception {
        this.myImpl.enableExceptionTelemetry();
    }

    public void disableExceptionTelemetry() throws Exception {
        this.myImpl.disableExceptionTelemetry();
    }

    public void clearExceptions() throws Exception {
        this.myImpl.clearExceptions();
    }

    public void advanceGeneration(String description) throws Exception {
        this.myImpl.advanceGeneration(description == null ? "" : description);
    }

    public long[] forceGC() throws Exception {
        return this.myImpl.forceGC();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    public void setUsedMemoryThreshold(int usedHeapPercent) throws Exception {
    }

    public int getUsedMemoryThreshold() throws Exception {
        return -1;
    }

    public void setTriggers(String triggersDescription, boolean append) throws Exception {
        this.myImpl.setTriggers(triggersDescription, append);
    }

    public String getTriggers() throws Exception {
        return this.myImpl.getTriggers();
    }

    private static void printHelp() {
        System.out.println(Constants.APP_FULL_NAME + " command line tools\n" + "\n" + "Usage: java -jar yjp-controller-api-redist.jar <host> <port> <command>\n" + "\n" + "where <command> is one of:\n" + "\n" + CMD_PRINT_STATUS + "\n" + CMD_CAPTURE_MEMORY_SNAPSHOT + "\n" + CMD_CAPTURE_PERFORMANCE_SNAPSHOT + "\n" + CMD_START_CPU_SAMPLING + " [" + CMD_NOJ2EE + "]\n" + CMD_START_CPU_TRACING + " [" + CMD_NOJ2EE + "]\n" + CMD_STOP_CPU_PROFILING + "\n" + CMD_CLEAR_CPU_DATA + "\n" + CMD_START_ALLOC_ALL + " [" + CMD_NOPERCLASSGC + "]\n" + "  // record each allocation\n" + CMD_START_ALLOC_ADAPTIVE + " [" + CMD_NOPERCLASSGC + "]\n" + " // record each 10th allocation, and all objects with size > 1M\n" + CMD_STOP_ALLOC + "\n" + CMD_CLEAR_ALLOC_DATA + "\n" + CMD_START_MONITOR_PROFILING + "\n" + CMD_STOP_MONITOR_PROFILING + "\n" + CMD_CLEAR_MONITOR_DATA + "\n" + "\n" + "Examples:\n" + "java -jar yjp-controller-api-redist.jar localhost 10001 " + CMD_CAPTURE_MEMORY_SNAPSHOT + "\n" + "java -jar yjp-controller-api-redist.jar localhost 10001 " + CMD_START_CPU_SAMPLING + "\n" + "java -jar yjp-controller-api-redist.jar localhost 10001 " + CMD_START_CPU_SAMPLING + " " + CMD_NOJ2EE + "\n");
    }

    public static void main(String[] args) throws Exception {
        Controller controller;
        int port;
        if (args.length != 3 && args.length != 4) {
            Controller.printHelp();
            return;
        }
        String host = args[0];
        String portStr = args[1];
        String command = args[2].toLowerCase();
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            System.out.println("Error: invalid port number specified: " + portStr);
            Controller.printHelp();
            return;
        }
        boolean garbagePerClass = true;
        boolean j2ee = true;
        if (args.length == 4) {
            String option = args[3];
            if (CMD_NOJ2EE.equals(option) && (CMD_START_CPU_SAMPLING.equals(command) || CMD_START_CPU_TRACING.equals(command))) {
                j2ee = false;
            } else if (CMD_NOPERCLASSGC.equals(option) && (CMD_START_ALLOC_ALL.equals(command) || CMD_START_ALLOC_ADAPTIVE.equals(command))) {
                garbagePerClass = false;
            } else {
                Controller.printHelp();
                return;
            }
        }
        if (CMD_CAPTURE_MEMORY_SNAPSHOT.equals(command)) {
            controller = new Controller(host, port);
            String path = controller.captureSnapshot(1L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_PERFORMANCE_SNAPSHOT.equals(command)) {
            controller = new Controller(host, port);
            String path = controller.captureSnapshot(0L);
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_START_CPU_SAMPLING.equals(command)) {
            controller = new Controller(host, port);
            controller.startCPUProfiling(4L | (j2ee ? 32L : 0L), null, null);
            System.out.println("CPU sampling started");
            return;
        }
        if (CMD_START_CPU_TRACING.equals(command)) {
            controller = new Controller(host, port);
            controller.startCPUProfiling(0xCL | (j2ee ? 32L : 0L), null, null);
            System.out.println("CPU tracing started");
            return;
        }
        if (CMD_STOP_CPU_PROFILING.equals(command)) {
            controller = new Controller(host, port);
            controller.stopCPUProfiling();
            System.out.println("CPU profiling stopped");
            return;
        }
        if (CMD_CLEAR_CPU_DATA.equals(command)) {
            controller = new Controller(host, port);
            controller.clearCPUData();
            System.out.println("CPU profiling data cleared");
            return;
        }
        if (CMD_START_ALLOC_ALL.equals(command)) {
            controller = new Controller(host, port);
            controller.startAllocationRecording(true, 1, false, 0, garbagePerClass);
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_START_ALLOC_ADAPTIVE.equals(command)) {
            controller = new Controller(host, port);
            controller.startAllocationRecording(true, 10, true, 0x100000, garbagePerClass);
            System.out.println("Allocation recording started");
            return;
        }
        if (CMD_STOP_ALLOC.equals(command)) {
            controller = new Controller(host, port);
            controller.stopAllocationRecording();
            System.out.println("Allocation recording stopped");
            return;
        }
        if (CMD_CLEAR_ALLOC_DATA.equals(command)) {
            controller = new Controller(host, port);
            controller.clearAllocationData();
            System.out.println("Allocation data cleared");
            return;
        }
        if (CMD_START_MONITOR_PROFILING.equals(command)) {
            controller = new Controller(host, port);
            controller.startMonitorProfiling();
            System.out.println("Monitor profiling started");
            return;
        }
        if (CMD_STOP_MONITOR_PROFILING.equals(command)) {
            controller = new Controller(host, port);
            controller.stopMonitorProfiling();
            System.out.println("Monitor profiling stopped");
            return;
        }
        if (CMD_CLEAR_MONITOR_DATA.equals(command)) {
            controller = new Controller(host, port);
            controller.clearMonitorData();
            System.out.println("Monitor data cleared");
            return;
        }
        if (CMD_PRINT_STATUS.equals(command)) {
            controller = new Controller(host, port);
            long status = controller.getStatus();
            if ((status & 2L) != 0L) {
                System.out.println("Allocation recording is on");
            } else {
                System.out.println("Allocation recording is off");
            }
            if ((status & 0xCL) == 12L) {
                System.out.println("CPU profiling is on (tracing)");
            } else if ((status & 4L) != 0L) {
                System.out.println("CPU profiling is on (sampling)");
            } else {
                System.out.println("CPU profiling is off");
            }
            if ((status & 0x80L) != 0L) {
                System.out.println("Monitor profiling is on");
            } else {
                System.out.println("Monitor profiling is off");
            }
            return;
        }
        Controller.printHelp();
    }
}

